/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.data.client;

import com.tiomadre.foragersinsight.common.block.BountifulLeavesBlock;
import com.tiomadre.foragersinsight.common.block.RoseCropBlock;
import com.tiomadre.foragersinsight.common.block.SliceableCakeBlock;
import com.tiomadre.foragersinsight.common.block.SpruceTipBlock;
import com.tiomadre.foragersinsight.common.block.TapperBlock;
import com.tiomadre.foragersinsight.core.registry.FIBlocks;
import com.tiomadre.foragersinsight.core.registry.FIItems;
import com.tiomadre.foragersinsight.data.client.FIBlockStatesHelper;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;

public class FIBlockStates
extends FIBlockStatesHelper {
    public FIBlockStates(GatherDataEvent e) {
        super(e.getGenerator().getPackOutput(), "foragersinsight", e.getExistingFileHelper());
    }

    protected void registerStatesAndModels() {
        this.sliceableCake();
        this.RoseCrop(FIBlocks.ROSE_CROP);
        this.RoselleCrop(FIBlocks.ROSELLE_CROP);
        this.age5Crop(FIBlocks.DANDELION_BUSH, FIItems.DANDELION_ROOT);
        this.age5Crop(FIBlocks.POPPY_BUSH, FIItems.POPPY_SEEDS);
        this.crateBlock(FIBlocks.APPLE_CRATE);
        this.sackBlock(FIBlocks.BLACK_ACORN_SACK);
        this.sackBlock(FIBlocks.ROSE_HIP_SACK);
        this.sackBlock(FIBlocks.ROSELLE_CALYX_SACK);
        this.sackBlock(FIBlocks.SPRUCE_TIPS_SACK);
        this.sackBlock(FIBlocks.POPPY_SEEDS_SACK);
        this.sackBlock(FIBlocks.DANDELION_ROOT_SACK);
        this.crossCutout(FIBlocks.BOUNTIFUL_OAK_SAPLING);
        this.bountifulLeaves(FIBlocks.BOUNTIFUL_OAK_LEAVES, Blocks.f_50050_);
        this.crossCutout(FIBlocks.BOUNTIFUL_DARK_OAK_SAPLING);
        this.bountifulLeaves(FIBlocks.BOUNTIFUL_DARK_OAK_LEAVES, Blocks.f_50055_);
        this.bountifulLeaves(FIBlocks.BOUNTIFUL_SPRUCE_LEAVES, Blocks.f_50051_);
        this.spruceTipBlock();
        this.axisBlock((RotatedPillarBlock)FIBlocks.SAPPY_BIRCH_LOG.get(), FIBlockStates.modTexture("sappy_birch_log"), this.mcLoc("block/birch_log_top"));
        this.blockItem((Block)FIBlocks.SAPPY_BIRCH_LOG.get());
        this.crossCutout(FIBlocks.BOUNTIFUL_SPRUCE_SAPLING);
        this.matBlock(FIBlocks.SCATTERED_ROSE_PETAL_MAT, "scattered_rose_petals");
        this.matBlock(FIBlocks.SCATTERED_ROSELLE_PETAL_MAT, "scattered_roselle_petals");
        this.matBlock(FIBlocks.SCATTERED_SPRUCE_TIP_MAT, "scattered_spruce_tips");
        this.matBlock(FIBlocks.SCATTERED_STRAW_MAT, "scattered_straw");
        this.matBlock(FIBlocks.DENSE_SPRUCE_TIP_MAT, "dense_spruce_tips");
        this.matBlock(FIBlocks.DENSE_ROSE_PETAL_MAT, "dense_rose_petals");
        this.matBlock(FIBlocks.DENSE_ROSELLE_PETAL_MAT, "dense_roselle_petals");
        this.matBlock(FIBlocks.DENSE_STRAW_MAT, "dense_straw");
        this.diffuserBlock();
        this.tapperBlock();
        this.crossCutout(FIBlocks.STOUT_BEACH_ROSE_BUSH);
        this.doubleCrossCutout(FIBlocks.ROSELLE_BUSH);
        this.doubleCrossCutout(FIBlocks.TALL_BEACH_ROSE_BUSH);
    }

    private void age5Crop(RegistryObject<Block> crop, RegistryObject<Item> seeds) {
        CropBlock cropBlock = (CropBlock)crop.get();
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)cropBlock);
        IntegerProperty age = (IntegerProperty)cropBlock.m_49965_().m_61081_("age");
        for (int i = 0; i <= cropBlock.m_7419_(); ++i) {
            builder.partialState().with((Property)age, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().cross("%s_stage%d".formatted(FIBlockStates.name((Block)cropBlock), i), FIBlockStates.concatRL(this.blockTexture((Block)cropBlock), "_stage%d".formatted(i)))).renderType("cutout")).addModel();
        }
        this.itemModels().basicItem((Item)seeds.get());
    }

    private void diffuserBlock() {
        Block diffuser = (Block)FIBlocks.DIFFUSER.get();
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(FIBlockStates.name((Block)diffuser))).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("block/block")))).texture("1", FIBlockStates.modTexture("diffuser_bottom"))).texture("2", FIBlockStates.modTexture("diffuser_side"))).texture("3", FIBlockStates.modTexture("diffuser_top"))).texture("particle", FIBlockStates.modTexture("diffuser_side"));
        model.element().from(4.0f, 0.0f, 4.0f).to(12.0f, 12.0f, 12.0f).face(Direction.NORTH).uvs(4.0f, 4.0f, 12.0f, 16.0f).texture("#2").end().face(Direction.EAST).uvs(4.0f, 4.0f, 12.0f, 16.0f).texture("#2").end().face(Direction.SOUTH).uvs(4.0f, 4.0f, 12.0f, 16.0f).texture("#2").end().face(Direction.WEST).uvs(4.0f, 4.0f, 12.0f, 16.0f).texture("#2").end().face(Direction.UP).uvs(4.0f, 4.0f, 12.0f, 12.0f).texture("#3").end().face(Direction.DOWN).uvs(4.0f, 4.0f, 12.0f, 12.0f).texture("#1").end().end();
        model.element().from(9.0f, 12.0f, 6.0f).to(10.0f, 14.0f, 10.0f).face(Direction.NORTH).uvs(9.0f, 2.0f, 10.0f, 4.0f).texture("#2").end().face(Direction.EAST).uvs(6.0f, 2.0f, 10.0f, 4.0f).texture("#2").end().face(Direction.SOUTH).uvs(6.0f, 2.0f, 7.0f, 4.0f).texture("#2").end().face(Direction.WEST).uvs(6.0f, 2.0f, 10.0f, 4.0f).texture("#2").end().face(Direction.UP).uvs(10.0f, 3.0f, 6.0f, 2.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#2").end().face(Direction.DOWN).uvs(6.0f, 2.0f, 10.0f, 4.0f).texture("#2").end().end();
        model.element().from(6.0f, 12.0f, 6.0f).to(7.0f, 14.0f, 10.0f).face(Direction.NORTH).uvs(9.0f, 2.0f, 10.0f, 4.0f).texture("#2").end().face(Direction.EAST).uvs(6.0f, 2.0f, 10.0f, 4.0f).texture("#2").end().face(Direction.SOUTH).uvs(6.0f, 2.0f, 7.0f, 4.0f).texture("#2").end().face(Direction.WEST).uvs(6.0f, 2.0f, 10.0f, 4.0f).texture("#2").end().face(Direction.UP).uvs(10.0f, 3.0f, 6.0f, 2.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#2").end().face(Direction.DOWN).uvs(6.0f, 2.0f, 10.0f, 4.0f).texture("#2").end().end();
        model.element().from(7.0f, 12.0f, 6.0f).to(9.0f, 14.0f, 7.0f).face(Direction.NORTH).uvs(7.0f, 2.0f, 9.0f, 4.0f).texture("#2").end().face(Direction.EAST).uvs(7.0f, 2.0f, 9.0f, 4.0f).texture("#2").end().face(Direction.SOUTH).uvs(7.0f, 2.0f, 9.0f, 4.0f).texture("#2").end().face(Direction.WEST).uvs(7.0f, 2.0f, 9.0f, 4.0f).texture("#2").end().face(Direction.UP).uvs(7.0f, 2.0f, 9.0f, 3.0f).texture("#2").end().face(Direction.DOWN).uvs(7.0f, 2.0f, 9.0f, 4.0f).texture("#2").end().end();
        model.element().from(7.0f, 12.0f, 9.0f).to(9.0f, 14.0f, 10.0f).face(Direction.NORTH).uvs(7.0f, 2.0f, 9.0f, 4.0f).texture("#2").end().face(Direction.EAST).uvs(7.0f, 2.0f, 9.0f, 4.0f).texture("#2").end().face(Direction.SOUTH).uvs(7.0f, 2.0f, 9.0f, 4.0f).texture("#2").end().face(Direction.WEST).uvs(7.0f, 2.0f, 9.0f, 4.0f).texture("#2").end().face(Direction.UP).uvs(7.0f, 2.0f, 9.0f, 3.0f).texture("#2").end().face(Direction.DOWN).uvs(7.0f, 2.0f, 9.0f, 4.0f).texture("#2").end().end();
        this.simpleBlock(diffuser, (ModelFile)model);
        this.blockItem(diffuser);
    }

    public void crossCutout(RegistryObject<? extends Block> cross) {
        this.simpleBlock((Block)cross.get(), (ModelFile)((BlockModelBuilder)this.models().cross(FIBlockStates.name((Block)((Block)cross.get())), this.blockTexture((Block)cross.get()))).renderType("cutout"));
        this.generatedItem((ItemLike)cross.get(), "block");
    }

    public void doubleCrossCutout(RegistryObject<? extends Block> plant) {
        DoublePlantBlock block = (DoublePlantBlock)plant.get();
        ModelBuilder lower = ((BlockModelBuilder)this.models().cross(FIBlockStates.name((Block)block) + "_lower", FIBlockStates.concatRL(this.blockTexture((Block)block), "_lower"))).renderType("cutout");
        ModelBuilder upper = ((BlockModelBuilder)this.models().cross(FIBlockStates.name((Block)block) + "_upper", FIBlockStates.concatRL(this.blockTexture((Block)block), "_upper"))).renderType("cutout");
        this.getVariantBuilder((Block)block).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)lower).addModel();
        this.getVariantBuilder((Block)block).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)upper).addModel();
        ((ItemModelBuilder)this.itemModels().withExistingParent(FIBlockStates.name((Block)block), this.mcLoc("item/generated"))).texture("layer0", FIBlockStates.concatRL(this.blockTexture((Block)block), "_lower"));
    }

    public void sackBlock(RegistryObject<? extends Block> block) {
        String name = FIBlockStates.name((Block)((Block)block.get()));
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)this.models().cube(name, FIBlockStates.modTexture(name + "_bottom"), FIBlockStates.modTexture(name + "_top"), FIBlockStates.modTexture(name + "_side"), FIBlockStates.modTexture(name + "_side_special"), FIBlockStates.modTexture(name + "_side"), FIBlockStates.modTexture(name + "_side"))).texture("particle", FIBlockStates.modTexture(name + "_top")));
        this.blockItem((Block)block.get());
    }

    public void crateBlock(RegistryObject<? extends Block> block) {
        String cropName = FIBlockStates.name((Block)((Block)block.get()));
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().cubeBottomTop(cropName, FIBlockStates.modTexture(cropName + "_side"), FIBlockStates.modTexture("crate_bottom"), FIBlockStates.modTexture(cropName + "_top")));
        this.blockItem((Block)block.get());
    }

    private void bountifulLeaves(RegistryObject<? extends Block> block, Block base) {
        Block leaves = (Block)block.get();
        if (leaves instanceof BountifulLeavesBlock) {
            BountifulLeavesBlock bountifulLeaves = (BountifulLeavesBlock)leaves;
            this.getVariantBuilder((Block)bountifulLeaves).forAllStatesExcept(state -> {
                int age = bountifulLeaves.getAge((BlockState)state);
                String stageName = "%s_stage%d".formatted(FIBlockStates.name((Block)bountifulLeaves), age);
                ModelBuilder stageModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(stageName, "foragersinsight:block/leaves_with_overlay")).texture("all", this.blockTexture(base))).texture("overlay", FIBlockStates.concatRL(this.blockTexture((Block)bountifulLeaves), "_stage%d".formatted(age)));
                return ConfiguredModel.builder().modelFile((ModelFile)stageModel).build();
            }, new Property[]{LeavesBlock.f_54418_, LeavesBlock.f_54419_, LeavesBlock.f_221367_});
            this.itemModels().withExistingParent(FIBlockStates.name((Block)bountifulLeaves), FIBlockStates.concatRL(this.blockTexture((Block)bountifulLeaves), "_stage0"));
            return;
        }
        if (leaves instanceof LeavesBlock) {
            LeavesBlock leavesBlock = (LeavesBlock)leaves;
            this.simpleBlock((Block)leavesBlock, (ModelFile)((BlockModelBuilder)this.models().cubeAll(FIBlockStates.name((Block)leavesBlock), this.blockTexture((Block)leavesBlock))).renderType("cutout_mipped"));
            this.blockItem((Block)leavesBlock);
        }
    }

    public void RoseCrop(RegistryObject<? extends Block> crop) {
        RoseCropBlock block = (RoseCropBlock)((Object)crop.get());
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            String half;
            int age;
            if (RoseCropBlock.isIllegalState(state)) {
                age = 0;
                half = "lower";
            } else {
                age = (Integer)state.m_61143_((Property)RoseCropBlock.AGE);
                half = state.m_61143_(RoseCropBlock.HALF) == DoubleBlockHalf.UPPER ? "upper" : "lower";
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("rose_hip_stage%d_%s".formatted(age, half), "block/cross")).texture("cross", FIBlockStates.concatRL(FIBlockStates.modTexture("rose_hip"), "_stage%d_%s".formatted(age, half)))).renderType("cutout")).build();
        });
        this.itemModels().basicItem(((Block)crop.get()).m_5456_());
    }

    public void RoselleCrop(RegistryObject<? extends Block> crop) {
        RoseCropBlock block = (RoseCropBlock)((Object)crop.get());
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            String half;
            int age;
            if (RoseCropBlock.isIllegalState(state)) {
                age = 0;
                half = "lower";
            } else {
                age = (Integer)state.m_61143_((Property)RoseCropBlock.AGE);
                half = state.m_61143_(RoseCropBlock.HALF) == DoubleBlockHalf.UPPER ? "upper" : "lower";
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("roselle_crop_stage%d_%s".formatted(age, half), "block/cross")).texture("cross", FIBlockStates.concatRL(FIBlockStates.modTexture("roselle_crop"), "_stage%d_%s".formatted(age, half)))).renderType("cutout")).build();
        });
        this.itemModels().basicItem(((Block)crop.get()).m_5456_());
    }

    public void matBlock(RegistryObject<? extends Block> block, String texture) {
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(FIBlockStates.name((Block)((Block)block.get())), this.mcLoc("block/carpet"))).texture("wool", FIBlockStates.modTexture(texture))).renderType("cutout"));
        this.blockItem((Block)block.get());
    }

    private void spruceTipBlock() {
        Block tip = (Block)FIBlocks.BOUNTIFUL_SPRUCE_TIPS.get();
        this.getVariantBuilder(tip).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross("%s_stage%d".formatted(FIBlockStates.name((Block)tip), state.m_61143_((Property)SpruceTipBlock.AGE)), FIBlockStates.concatRL(this.blockTexture(tip), "_stage%d".formatted(state.m_61143_((Property)SpruceTipBlock.AGE))))).renderType("cutout")).build());
    }

    private void tapperBlock() {
        Block tapper = (Block)FIBlocks.TAPPER.get();
        ModelFile[] fillModels = new ModelFile[]{this.tapperModel(FIBlockStates.name((Block)tapper), "bucket_top_stage0", "bucket_side", "knife_tap"), this.tapperModel(FIBlockStates.name((Block)tapper) + "_stage1", "bucket_top_stage1", "bucket_side", "sappy_knife_tap"), this.tapperModel(FIBlockStates.name((Block)tapper) + "_stage2", "bucket_top_stage2", "bucket_side", "sappy_knife_tap"), this.tapperModel(FIBlockStates.name((Block)tapper) + "_stage3", "bucket_top_stage3", "bucket_side", "sappy_knife_tap"), this.tapperModel(FIBlockStates.name((Block)tapper) + "_stage4", "bucket_top_stage4", "bucket_side_full", "sappy_knife_tap")};
        VariantBlockStateBuilder builder = this.getVariantBuilder(tapper);
        for (int fill = 0; fill < fillModels.length; ++fill) {
            ModelFile model = fillModels[fill];
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                int rotationY = switch (direction) {
                    case Direction.EAST -> 90;
                    case Direction.SOUTH -> 180;
                    case Direction.WEST -> 270;
                    default -> 0;
                };
                builder.partialState().with((Property)TapperBlock.FILL, (Comparable)Integer.valueOf(fill)).with((Property)TapperBlock.FACING, (Comparable)direction).modelForState().modelFile(model).rotationY((int)direction.m_122435_()).addModel();
            }
        }
    }

    private void sliceableCake() {
        SliceableCakeBlock cake = (SliceableCakeBlock)((Object)FIBlocks.ACORN_CARROT_CAKE.get());
        String name = FIBlockStates.name((Block)cake);
        VariantBlockStateBuilder builder = this.getVariantBuilder(cake);
        for (int bites = 0; bites < cake.getMaxBites(); ++bites) {
            Object parent = bites == 0 ? "block/cake" : "block/cake_slice" + bites;
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent((String)(bites == 0 ? name : name + "_slice" + bites), this.mcLoc((String)parent))).texture("particle", FIBlockStates.modTexture(name + "_side"))).texture("bottom", FIBlockStates.modTexture(name + "_bottom"))).texture("top", FIBlockStates.modTexture(name + "_top"))).texture("side", FIBlockStates.modTexture(name + "_side"))).texture("inner", FIBlockStates.modTexture(name + "_inner"));
            builder.partialState().with((Property)SliceableCakeBlock.BITES, (Comparable)Integer.valueOf(bites)).modelForState().modelFile((ModelFile)model).addModel();
        }
    }

    private ModelFile tapperModel(String name, String bucketTop, String bucketSide, String tapTexture) {
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).texture("particle", FIBlockStates.modTexture(bucketTop))).texture("4", FIBlockStates.modTexture(bucketTop))).texture("7", FIBlockStates.modTexture("bucket_bottom"))).texture("8", FIBlockStates.modTexture(bucketSide))).texture("12", FIBlockStates.modTexture(tapTexture));
        builder.element().from(7.5f, 12.0f, 0.0f).to(8.5f, 15.0f, 6.0f).face(Direction.NORTH).uvs(8.0f, 5.0f, 9.0f, 8.0f).texture("#12").end().face(Direction.EAST).uvs(0.0f, 1.0f, 6.0f, 4.0f).texture("#12").end().face(Direction.SOUTH).uvs(5.0f, 5.0f, 4.0f, 8.0f).texture("#12").end().face(Direction.WEST).uvs(0.0f, 1.0f, 6.0f, 4.0f).texture("#12").end().face(Direction.UP).uvs(6.0f, 1.0f, 0.0f, 2.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#12").end().face(Direction.DOWN).uvs(6.0f, 3.0f, 0.0f, 4.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#12").end().end();
        builder.element().from(7.5f, 13.0f, 6.0f).to(8.5f, 15.0f, 11.0f).face(Direction.NORTH).uvs(10.0f, 1.0f, 9.0f, 3.0f).texture("#12").end().face(Direction.EAST).uvs(10.0f, 3.0f, 5.0f, 1.0f).texture("#12").end().face(Direction.SOUTH).uvs(9.0f, 1.0f, 10.0f, 3.0f).texture("#12").end().face(Direction.WEST).uvs(5.0f, 3.0f, 10.0f, 1.0f).texture("#12").end().face(Direction.UP).uvs(10.0f, 1.0f, 5.0f, 2.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#12").end().face(Direction.DOWN).uvs(10.0f, 1.0f, 5.0f, 2.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#12").end().end();
        builder.element().from(3.5f, 2.0f, 1.0f).to(12.5f, 11.0f, 10.0f).face(Direction.NORTH).uvs(0.0f, 2.0f, 9.0f, 11.0f).texture("#8").end().face(Direction.EAST).uvs(0.0f, 2.0f, 9.0f, 11.0f).texture("#8").end().face(Direction.SOUTH).uvs(0.0f, 2.0f, 9.0f, 11.0f).texture("#8").end().face(Direction.WEST).uvs(0.0f, 2.0f, 9.0f, 11.0f).texture("#8").end().face(Direction.UP).uvs(0.0f, 0.0f, 9.0f, 9.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#4").end().face(Direction.DOWN).uvs(0.0f, 0.0f, 9.0f, 9.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#7").end().end();
        builder.element().from(11.5f, 11.0f, 5.0f).to(11.5f, 15.0f, 6.0f).face(Direction.NORTH).uvs(10.0f, 6.0f, 11.0f, 1.0f).texture("#8").end().face(Direction.EAST).uvs(10.0f, 5.0f, 11.0f, 1.0f).texture("#8").end().face(Direction.SOUTH).uvs(10.0f, 6.0f, 11.0f, 1.0f).texture("#8").end().face(Direction.WEST).uvs(10.0f, 5.0f, 11.0f, 1.0f).texture("#8").end().face(Direction.UP).uvs(10.0f, 6.0f, 11.0f, 1.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#8").end().face(Direction.DOWN).uvs(10.0f, 5.0f, 11.0f, 1.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#8").end().end();
        builder.element().from(4.5f, 11.0f, 5.0f).to(4.5f, 15.0f, 6.0f).face(Direction.NORTH).uvs(10.0f, 6.0f, 11.0f, 1.0f).texture("#8").end().face(Direction.EAST).uvs(10.0f, 5.0f, 11.0f, 1.0f).texture("#8").end().face(Direction.SOUTH).uvs(10.0f, 6.0f, 11.0f, 1.0f).texture("#8").end().face(Direction.WEST).uvs(10.0f, 5.0f, 11.0f, 1.0f).texture("#8").end().face(Direction.UP).uvs(10.0f, 6.0f, 11.0f, 1.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#8").end().face(Direction.DOWN).uvs(10.0f, 5.0f, 11.0f, 1.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#8").end().end();
        builder.element().from(4.5f, 15.0f, 5.0f).to(11.5f, 15.0f, 6.0f).face(Direction.NORTH).uvs(10.0f, 1.0f, 11.0f, 10.0f).texture("#8").end().face(Direction.EAST).uvs(10.0f, 1.0f, 11.0f, 10.0f).texture("#8").end().face(Direction.SOUTH).uvs(10.0f, 1.0f, 11.0f, 10.0f).texture("#8").end().face(Direction.WEST).uvs(10.0f, 1.0f, 11.0f, 10.0f).texture("#8").end().face(Direction.UP).uvs(10.0f, 0.0f, 11.0f, 7.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#8").end().face(Direction.DOWN).uvs(10.0f, 0.0f, 11.0f, 7.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#8").end().end();
        return builder;
    }
}

