/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.foragersinsight.data.server;

import com.google.common.collect.ImmutableList;
import com.tiomadre.foragersinsight.common.block.BountifulLeavesBlock;
import com.tiomadre.foragersinsight.common.block.DandelionBushBlock;
import com.tiomadre.foragersinsight.common.block.PoppyBushBlock;
import com.tiomadre.foragersinsight.common.block.RoseCropBlock;
import com.tiomadre.foragersinsight.core.registry.FIBlocks;
import com.tiomadre.foragersinsight.core.registry.FIItems;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.tag.ModTags;

public class FILoot
extends LootTableProvider {
    protected static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    protected static final LootItemCondition.Builder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.m_81807_();
    protected static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
    private static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_285888_(HAS_SILK_TOUCH);
    private static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.m_81807_();
    private static final float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

    public FILoot(GatherDataEvent e) {
        super(e.getGenerator().getPackOutput(), BuiltInLootTables.m_78766_(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(FIBlockLoot::new, LootContextParamSets.f_81421_)));
    }

    protected void validate(@NotNull Map<ResourceLocation, LootTable> map, @NotNull ValidationContext context) {
    }

    private static class FIBlockLoot
    extends BlockLootSubProvider {
        private static final Set<Item> EXPLOSION_RESISTANT = Stream.of(Blocks.f_50260_, Blocks.f_50273_, Blocks.f_50569_, Blocks.f_50310_, Blocks.f_50312_, Blocks.f_50316_, Blocks.f_50314_, Blocks.f_50318_, Blocks.f_50320_, Blocks.f_260630_, Blocks.f_50456_, Blocks.f_50525_, Blocks.f_50521_, Blocks.f_50522_, Blocks.f_50466_, Blocks.f_50464_, Blocks.f_50523_, Blocks.f_50460_, Blocks.f_50465_, Blocks.f_50462_, Blocks.f_50459_, Blocks.f_50458_, Blocks.f_50463_, Blocks.f_50520_, Blocks.f_50524_, Blocks.f_50457_, Blocks.f_50461_).map(ItemLike::m_5456_).collect(Collectors.toSet());
        private static final LootItemCondition.Builder HAS_KNIFE = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ModTags.KNIVES));

        protected FIBlockLoot() {
            super(EXPLOSION_RESISTANT, FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            this.m_247577_((Block)FIBlocks.ROSE_CROP.get(), (LootTable.Builder)this.m_246108_((ItemLike)FIItems.ROSE_HIP.get(), (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_(FIBlockLoot.isUpperOrLower(FIBlocks.ROSE_CROP)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FIItems.ROSE_HIP.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_79080_(FIBlockLoot.stateCond(FIBlocks.ROSE_CROP, (Property<Integer>)RoseCropBlock.AGE, 4))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FIItems.ROSE_PETALS.get())).m_79080_(HAS_KNIFE)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)))))));
            this.m_247577_((Block)FIBlocks.ROSELLE_CROP.get(), (LootTable.Builder)this.m_246108_((ItemLike)FIItems.ROSELLE_CALYX.get(), (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_(FIBlockLoot.isUpperOrLower(FIBlocks.ROSELLE_CROP)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FIItems.ROSELLE_CALYX.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714285f, (int)3))).m_79080_(FIBlockLoot.stateCond(FIBlocks.ROSELLE_CROP, (Property<Integer>)RoseCropBlock.AGE, 4))).m_79161_(LootPool.m_79043_().m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)FIItems.ROSELLE_PETALS.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))).m_79080_(HAS_KNIFE)))));
            this.createFlowerBushDrops(FIBlocks.DANDELION_BUSH, FIItems.DANDELION_ROOT, Items.f_42539_, DandelionBushBlock.AGE, 4);
            this.createFlowerBushDrops(FIBlocks.POPPY_BUSH, FIItems.POPPY_SEEDS, Items.f_42497_, PoppyBushBlock.AGE, 4);
            this.m_245724_((Block)FIBlocks.ACORN_CARROT_CAKE.get());
            this.m_245724_((Block)FIBlocks.ROSE_HIP_SACK.get());
            this.m_245724_((Block)FIBlocks.APPLE_CRATE.get());
            this.m_245724_((Block)FIBlocks.BLACK_ACORN_SACK.get());
            this.m_245724_((Block)FIBlocks.SPRUCE_TIPS_SACK.get());
            this.m_245724_((Block)FIBlocks.ROSELLE_CALYX_SACK.get());
            this.m_245724_((Block)FIBlocks.DANDELION_ROOT_SACK.get());
            this.m_245724_((Block)FIBlocks.POPPY_SEEDS_SACK.get());
            this.m_246481_((Block)FIBlocks.ROSELLE_BUSH.get(), block -> LootTable.m_79147_().m_79161_(((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)))));
            this.m_246481_((Block)FIBlocks.TALL_BEACH_ROSE_BUSH.get(), block -> LootTable.m_79147_().m_79161_(((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)))));
            this.m_246481_((Block)FIBlocks.STOUT_BEACH_ROSE_BUSH.get(), block -> LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)))).m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_())));
            this.m_245724_((Block)FIBlocks.SCATTERED_ROSE_PETAL_MAT.get());
            this.m_245724_((Block)FIBlocks.SCATTERED_ROSELLE_PETAL_MAT.get());
            this.m_245724_((Block)FIBlocks.SCATTERED_SPRUCE_TIP_MAT.get());
            this.m_245724_((Block)FIBlocks.SCATTERED_STRAW_MAT.get());
            this.m_245724_((Block)FIBlocks.DENSE_STRAW_MAT.get());
            this.m_245724_((Block)FIBlocks.DENSE_SPRUCE_TIP_MAT.get());
            this.m_245724_((Block)FIBlocks.DENSE_ROSE_PETAL_MAT.get());
            this.m_245724_((Block)FIBlocks.DENSE_ROSELLE_PETAL_MAT.get());
            this.m_245724_((Block)FIBlocks.BOUNTIFUL_OAK_SAPLING.get());
            this.m_245724_((Block)FIBlocks.BOUNTIFUL_DARK_OAK_SAPLING.get());
            this.m_245724_((Block)FIBlocks.BOUNTIFUL_SPRUCE_SAPLING.get());
            this.m_247577_((Block)FIBlocks.BOUNTIFUL_SPRUCE_TIPS.get(), LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_));
            this.m_246481_((Block)FIBlocks.SAPPY_BIRCH_LOG.get(), block -> FIBlockLoot.m_247502_((Block)block, (LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50001_)));
            this.m_247577_((Block)FIBlocks.BOUNTIFUL_OAK_LEAVES.get(), this.createBountifulLeavesDrops(FIBlocks.BOUNTIFUL_OAK_LEAVES, (ItemLike)FIBlocks.BOUNTIFUL_OAK_SAPLING.get()));
            this.m_247577_((Block)FIBlocks.BOUNTIFUL_DARK_OAK_LEAVES.get(), this.createBountifulLeavesDrops(FIBlocks.BOUNTIFUL_DARK_OAK_LEAVES, (ItemLike)FIBlocks.BOUNTIFUL_DARK_OAK_SAPLING.get()));
            this.m_247577_((Block)FIBlocks.BOUNTIFUL_SPRUCE_LEAVES.get(), this.createSpruceLeavesDrops((Block)FIBlocks.BOUNTIFUL_SPRUCE_LEAVES.get(), (ItemLike)FIBlocks.BOUNTIFUL_SPRUCE_SAPLING.get()));
            this.m_246481_((Block)FIBlocks.DIFFUSER.get(), block -> this.m_247033_((ItemLike)FIItems.DIFFUSER.get()));
            this.m_246481_((Block)FIBlocks.TAPPER.get(), block -> this.m_247033_((ItemLike)FIItems.TAPPER.get()));
        }

        private void createFlowerBushDrops(RegistryObject<? extends Block> registryBlock, RegistryObject<Item> registrySeed, Item originalFlower, IntegerProperty ageProperty, int maxAge) {
            Block bush = (Block)registryBlock.get();
            Item seed = (Item)registrySeed.get();
            this.m_247577_(bush, (LootTable.Builder)this.m_246108_((ItemLike)seed, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)seed))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)seed)).m_79080_(FIBlockLoot.stateCond(registryBlock, (Property<Integer>)ageProperty, maxAge))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)originalFlower).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_79080_(FIBlockLoot.stateCond(registryBlock, (Property<Integer>)ageProperty, maxAge)).m_79080_(HAS_KNIFE)).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)seed).m_79080_(FIBlockLoot.stateCond(registryBlock, (Property<Integer>)ageProperty, maxAge))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714285f, (int)3))))));
        }

        private LootTable.Builder createBountifulLeavesDrops(RegistryObject<? extends Block> leafBlock, ItemLike sapling) {
            BountifulLeavesBlock block = (BountifulLeavesBlock)((Object)leafBlock.get());
            return FIBlockLoot.m_246160_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)sapling))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])VanillaBlockLoot.f_244509_))).m_79161_(LootPool.m_79043_().m_79080_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])NORMAL_LEAVES_STICK_CHANCES)))).m_79161_(LootPool.m_79043_().m_79080_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79080_(FIBlockLoot.stateCond(leafBlock, (Property<Integer>)BountifulLeavesBlock.AGE, 3)).m_79076_((LootPoolEntryContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)block.getBounty()))));
        }

        private LootTable.Builder createSpruceLeavesDrops(Block leaves, ItemLike sapling) {
            return FIBlockLoot.m_246160_((Block)leaves, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)leaves, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)sapling))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])VanillaBlockLoot.f_244509_))).m_79161_(LootPool.m_79043_().m_79080_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)this.m_246108_((ItemLike)leaves, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])NORMAL_LEAVES_STICK_CHANCES))));
        }

        public static LootItemCondition.Builder stateCond(RegistryObject<? extends Block> block, String value) {
            return LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67700_(RoseCropBlock.HALF, value));
        }

        private static LootItemCondition.Builder isUpper(RegistryObject<? extends Block> block) {
            return FIBlockLoot.stateCond(block, DoubleBlockHalf.UPPER.toString());
        }

        private static LootItemCondition.Builder isLower(RegistryObject<? extends Block> block) {
            return FIBlockLoot.stateCond(block, DoubleBlockHalf.LOWER.toString());
        }

        private static LootItemCondition.Builder isUpperOrLower(RegistryObject<? extends Block> block) {
            return FIBlockLoot.isUpper(block).m_285888_(FIBlockLoot.isLower(block));
        }

        private static LootItemCondition.Builder stateCond(RegistryObject<? extends Block> block, Property<Integer> property, int value) {
            return LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_(property, value));
        }

        @NotNull
        public Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey(block)).m_135827_().equals("foragersinsight")).collect(Collectors.toSet());
        }
    }
}

