/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.letmeclickandsend;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import me.fallenbreath.letmeclickandsend.LetMeClickAndSendMod;

public class LmcasConfig {
    private static final LmcasConfig INSTANCE = new LmcasConfig();
    private Pattern sendChatPattern;

    public static LmcasConfig getInstance() {
        return INSTANCE;
    }

    public void load() {
        Path configDir = Paths.get("config", "letmeclickandsend");
        Path configFile = configDir.resolve("config.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            ConfigData configData;
            Files.createDirectories(configDir, new FileAttribute[0]);
            if (!Files.exists(configFile, new LinkOption[0])) {
                try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("assets/letmeclickandsend/default_config.json");){
                    if (inputStream == null) {
                        throw new IOException("Default config file not found in resources");
                    }
                    Files.copy(inputStream, configFile, new CopyOption[0]);
                }
            }
            try (BufferedReader reader = Files.newBufferedReader(configFile, StandardCharsets.UTF_8);){
                configData = (ConfigData)gson.fromJson((Reader)reader, ConfigData.class);
            }
            this.readConfigData(configData);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load or create config file: " + String.valueOf(configFile), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid config format: " + e.getMessage(), e);
        }
    }

    private void readConfigData(ConfigData configData) {
        LetMeClickAndSendMod.LOGGER.info("LMCAS sendChatPattern: `{}`", (Object)configData.sendChatPattern);
        this.sendChatPattern = Pattern.compile(configData.sendChatPattern, 32);
    }

    public Pattern getSendChatPattern() {
        return this.sendChatPattern;
    }

    private static class ConfigData {
        public String sendChatPattern = "!!.*";

        private ConfigData() {
        }
    }
}

