/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.api.block.BlockBreakBehavior;
import com.example.modloader.api.block.BlockExplodeBehavior;
import com.example.modloader.api.block.BlockInteractBehavior;
import com.example.modloader.api.block.BlockPlaceBehavior;
import com.example.modloader.api.block.BlockRedstoneBehavior;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.TileState;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class CustomBlock {
    private final String id;
    private final Material baseMaterial;
    private final int customModelData;
    private final String displayName;
    private final List<String> lore;
    private final BlockPlaceBehavior placeBehavior;
    private final BlockBreakBehavior breakBehavior;
    private final BlockInteractBehavior interactBehavior;
    private final BlockRedstoneBehavior redstoneBehavior;
    private final BlockExplodeBehavior explodeBehavior;
    private final List<ItemStack> customDrops;

    public CustomBlock(String id, Material baseMaterial, int customModelData, String displayName, List<String> lore, BlockPlaceBehavior placeBehavior, BlockBreakBehavior breakBehavior, BlockInteractBehavior interactBehavior, BlockRedstoneBehavior redstoneBehavior, BlockExplodeBehavior explodeBehavior, List<ItemStack> customDrops) {
        this.id = id;
        this.baseMaterial = baseMaterial;
        this.customModelData = customModelData;
        this.displayName = displayName;
        this.lore = lore != null ? Collections.unmodifiableList(lore) : Collections.emptyList();
        this.placeBehavior = placeBehavior;
        this.breakBehavior = breakBehavior;
        this.interactBehavior = interactBehavior;
        this.redstoneBehavior = redstoneBehavior;
        this.explodeBehavior = explodeBehavior;
        this.customDrops = customDrops != null ? Collections.unmodifiableList(customDrops) : Collections.emptyList();
    }

    public String getId() {
        return this.id;
    }

    public Material getBaseMaterial() {
        return this.baseMaterial;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public BlockPlaceBehavior getPlaceBehavior() {
        return this.placeBehavior;
    }

    public BlockBreakBehavior getBreakBehavior() {
        return this.breakBehavior;
    }

    public BlockInteractBehavior getInteractBehavior() {
        return this.interactBehavior;
    }

    public BlockRedstoneBehavior getRedstoneBehavior() {
        return this.redstoneBehavior;
    }

    public BlockExplodeBehavior getExplodeBehavior() {
        return this.explodeBehavior;
    }

    public List<ItemStack> getCustomDrops() {
        return this.customDrops;
    }

    public NamespacedKey getNamespacedKey(Plugin plugin) {
        return new NamespacedKey(plugin, this.id);
    }

    public ItemStack getItemStack() {
        ItemStack item = new ItemStack(this.baseMaterial);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.displayName);
            meta.setLore(this.lore);
            meta.setCustomModelData(Integer.valueOf(this.customModelData));
            item.setItemMeta(meta);
        }
        return item;
    }

    public PersistentDataContainer getPersistentDataContainer(World world, Location location) {
        Block block = world.getBlockAt(location);
        if (block.getState() instanceof TileState) {
            return ((TileState)block.getState()).getPersistentDataContainer();
        }
        return null;
    }
}

