/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.CustomBlock;
import com.example.modloader.api.block.BlockBreakBehavior;
import com.example.modloader.api.block.BlockExplodeBehavior;
import com.example.modloader.api.block.BlockInteractBehavior;
import com.example.modloader.api.block.BlockPlaceBehavior;
import com.example.modloader.api.block.BlockRedstoneBehavior;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CustomBlockRegistry
implements Listener {
    private final Plugin plugin;
    private final Logger logger;
    private final Map<String, CustomBlock> registeredCustomBlocks = new HashMap<String, CustomBlock>();
    private final NamespacedKey customBlockIdKey;

    public CustomBlockRegistry(Plugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.customBlockIdKey = new NamespacedKey(plugin, "custom_block_id");
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    public void register(CustomBlock customBlock) {
        if (this.registeredCustomBlocks.containsKey(customBlock.getId())) {
            this.logger.warning("Custom block with ID '" + customBlock.getId() + "' already registered. Skipping.");
            return;
        }
        this.registeredCustomBlocks.put(customBlock.getId(), customBlock);
        this.logger.info("Registered custom block: " + customBlock.getId() + " (based on " + customBlock.getBaseMaterial().name() + ")");
    }

    public CustomBlock getCustomBlock(String id) {
        return this.registeredCustomBlocks.get(id);
    }

    public CustomBlock getCustomBlockFromWorldBlock(Block block) {
        PersistentDataContainer container;
        BlockState state = block.getState();
        if (state instanceof TileState && (container = ((TileState)state).getPersistentDataContainer()).has(this.customBlockIdKey, PersistentDataType.STRING)) {
            String customBlockId = (String)container.get(this.customBlockIdKey, PersistentDataType.STRING);
            return this.registeredCustomBlocks.get(customBlockId);
        }
        return null;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemStack itemInHand = event.getItemInHand();
        CustomBlock customBlock = this.getCustomBlockFromItemStack(itemInHand);
        if (customBlock != null) {
            Block placedBlock = event.getBlockPlaced();
            BlockState state = placedBlock.getState();
            if (state instanceof TileState) {
                ((TileState)state).getPersistentDataContainer().set(this.customBlockIdKey, PersistentDataType.STRING, (Object)customBlock.getId());
                state.update(true);
            }
            this.logger.info("Custom block '" + customBlock.getId() + "' placed at " + String.valueOf(placedBlock.getLocation()));
            BlockPlaceBehavior behavior = customBlock.getPlaceBehavior();
            if (behavior != null) {
                behavior.onPlace(event, placedBlock, event.getPlayer());
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block brokenBlock = event.getBlock();
        CustomBlock customBlock = this.getCustomBlockFromWorldBlock(brokenBlock);
        if (customBlock != null) {
            this.logger.info("Custom block '" + customBlock.getId() + "' broken at " + String.valueOf(brokenBlock.getLocation()));
            BlockBreakBehavior behavior = customBlock.getBreakBehavior();
            if (behavior != null) {
                behavior.onBreak(event, brokenBlock, event.getPlayer());
            }
            if (!event.isCancelled()) {
                event.setDropItems(false);
                List<ItemStack> drops = customBlock.getCustomDrops();
                if (drops.isEmpty()) {
                    brokenBlock.getWorld().dropItemNaturally(brokenBlock.getLocation(), customBlock.getItemStack());
                } else {
                    for (ItemStack drop : drops) {
                        brokenBlock.getWorld().dropItemNaturally(brokenBlock.getLocation(), drop);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        CustomBlock customBlock = this.getCustomBlockFromWorldBlock(clickedBlock);
        if (customBlock != null) {
            this.logger.info("Player interacted with custom block '" + customBlock.getId() + "' at " + String.valueOf(clickedBlock.getLocation()));
            BlockInteractBehavior behavior = customBlock.getInteractBehavior();
            if (behavior != null) {
                behavior.onInteract(event, clickedBlock, event.getPlayer());
            }
        }
    }

    @EventHandler
    public void onBlockRedstone(BlockRedstoneEvent event) {
        BlockRedstoneBehavior behavior;
        Block block = event.getBlock();
        CustomBlock customBlock = this.getCustomBlockFromWorldBlock(block);
        if (customBlock != null && (behavior = customBlock.getRedstoneBehavior()) != null) {
            behavior.onRedstone(event, block, event.getOldCurrent(), event.getNewCurrent());
        }
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        ArrayList blocks = new ArrayList(event.blockList());
        for (Block block : blocks) {
            BlockExplodeBehavior behavior;
            CustomBlock customBlock = this.getCustomBlockFromWorldBlock(block);
            if (customBlock == null || (behavior = customBlock.getExplodeBehavior()) == null) continue;
            behavior.onExplode(event, block, event.blockList(), event.getYield());
        }
    }

    private CustomBlock getCustomBlockFromItemStack(ItemStack itemStack) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null || !meta.hasCustomModelData()) {
            return null;
        }
        for (CustomBlock customBlock : this.registeredCustomBlocks.values()) {
            if (customBlock.getCustomModelData() != meta.getCustomModelData() || customBlock.getBaseMaterial() != itemStack.getType()) continue;
            return customBlock;
        }
        return null;
    }

    public void unregisterAll() {
        this.registeredCustomBlocks.clear();
        HandlerList.unregisterAll((Listener)this);
        this.logger.info("Unregistered all custom block definitions and event listener.");
    }
}

