/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.api.ModCommandExecutor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

public class CustomCommandRegistry {
    private final Plugin plugin;
    private final Logger logger;
    private CommandMap commandMap;
    private final Map<String, String> registeredCommandMods = new HashMap<String, String>();
    private final Map<String, Command> registeredCommands = new HashMap<String, Command>();

    public CustomCommandRegistry(Plugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        try {
            if (plugin.getServer().getPluginManager() instanceof SimplePluginManager) {
                Field f = SimplePluginManager.class.getDeclaredField("commandMap");
                f.setAccessible(true);
                this.commandMap = (CommandMap)f.get(plugin.getServer().getPluginManager());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.logger.severe("Failed to get Bukkit CommandMap: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void register(String commandName, final ModCommandExecutor modExecutor, String modId) {
        if (this.commandMap == null) {
            this.logger.warning("CommandMap not available, cannot register command: " + commandName);
            return;
        }
        if (this.registeredCommandMods.containsKey(commandName)) {
            this.logger.warning("Command '" + commandName + "' already registered by mod '" + this.registeredCommandMods.get(commandName) + "'. Skipping registration by '" + modId + "'.");
            return;
        }
        Command bukkitCommand = new Command(this, commandName){

            public boolean execute(CommandSender sender, String commandLabel, String[] args) {
                return modExecutor.onCommand(sender, commandLabel, args);
            }

            public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
                List completions = modExecutor.onTabComplete(sender, alias, args);
                return completions != null ? completions : super.tabComplete(sender, alias, args);
            }
        };
        this.commandMap.register(this.plugin.getName(), bukkitCommand);
        this.registeredCommandMods.put(commandName, modId);
        this.registeredCommands.put(commandName, bukkitCommand);
        this.logger.info("Registered custom command: /" + commandName + " by mod " + modId);
    }

    public void unregisterAll(String modId) {
        if (this.commandMap == null) {
            return;
        }
        ArrayList<String> commandsToRemove = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.registeredCommandMods.entrySet()) {
            if (!entry.getValue().equals(modId)) continue;
            commandsToRemove.add(entry.getKey());
        }
        for (String commandName : commandsToRemove) {
            Command command = this.registeredCommands.get(commandName);
            if (command == null) continue;
            command.unregister(this.commandMap);
            this.registeredCommands.remove(commandName);
            this.registeredCommandMods.remove(commandName);
            this.logger.info("Unregistered custom command: /" + commandName + " from mod " + modId);
        }
    }

    public void unregisterAll() {
        if (this.commandMap == null) {
            return;
        }
        for (String commandName : new ArrayList<String>(this.registeredCommands.keySet())) {
            Command command = this.registeredCommands.get(commandName);
            if (command == null) continue;
            command.unregister(this.commandMap);
            this.logger.info("Unregistered custom command: /" + commandName);
        }
        this.registeredCommands.clear();
        this.registeredCommandMods.clear();
    }
}

