/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class CustomEnchantment
extends Enchantment {
    private final String name;
    private final int maxLevel;
    private final EnchantmentTarget itemTarget;
    private final boolean treasure;
    private final boolean cursed;
    private final NamespacedKey key;

    protected CustomEnchantment(JavaPlugin plugin, String namespace, String name, int maxLevel, EnchantmentTarget itemTarget, boolean treasure, boolean cursed) {
        this.key = new NamespacedKey((Plugin)plugin, namespace);
        this.name = name;
        this.maxLevel = maxLevel;
        this.itemTarget = itemTarget;
        this.treasure = treasure;
        this.cursed = cursed;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public boolean isSupported() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getStartLevel() {
        return 1;
    }

    public EnchantmentTarget getItemTarget() {
        return this.itemTarget;
    }

    public boolean isTreasure() {
        return this.treasure;
    }

    public boolean isCursed() {
        return this.cursed;
    }

    public boolean conflictsWith(Enchantment other) {
        return false;
    }

    public boolean canEnchantItem(ItemStack item) {
        return this.itemTarget.includes(item);
    }
}

