/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class CustomEventListenerRegistry {
    private final Plugin plugin;
    private final Logger logger;
    private final PluginManager pluginManager;
    private final Map<Listener, String> registeredListenerMods = new HashMap<Listener, String>();
    private final List<Listener> registeredListeners = new ArrayList<Listener>();

    public CustomEventListenerRegistry(Plugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.pluginManager = plugin.getServer().getPluginManager();
    }

    public void register(Listener listener, String modId) {
        this.pluginManager.registerEvents(listener, this.plugin);
        this.registeredListeners.add(listener);
        this.registeredListenerMods.put(listener, modId);
        this.logger.info("Registered custom event listener: " + listener.getClass().getName() + " by mod " + modId);
    }

    public void unregisterAll(String modId) {
        ArrayList<Listener> listenersToRemove = new ArrayList<Listener>();
        for (Map.Entry<Listener, String> entry : this.registeredListenerMods.entrySet()) {
            if (!entry.getValue().equals(modId)) continue;
            listenersToRemove.add(entry.getKey());
        }
        for (Listener listener : listenersToRemove) {
            HandlerList.unregisterAll((Listener)listener);
            this.registeredListeners.remove(listener);
            this.registeredListenerMods.remove(listener);
            this.logger.info("Unregistered custom event listener: " + listener.getClass().getName() + " from mod " + modId);
        }
    }

    public void unregisterAll() {
        for (Listener listener : new ArrayList<Listener>(this.registeredListeners)) {
            HandlerList.unregisterAll((Listener)listener);
            this.logger.info("Unregistered custom event listener: " + listener.getClass().getName());
        }
        this.registeredListeners.clear();
        this.registeredListenerMods.clear();
    }
}

