/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.CustomMob;
import com.example.modloader.api.mob.CustomMobSpawner;
import com.example.modloader.mob.CustomMobGoalExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CustomMobRegistry
implements Listener {
    private final Plugin plugin;
    private final Logger logger;
    private final Map<String, CustomMob> registeredCustomMobs = new HashMap<String, CustomMob>();
    private final Map<LivingEntity, CustomMobGoalExecutor> goalExecutors = new HashMap<LivingEntity, CustomMobGoalExecutor>();
    private final List<CustomMobSpawner> registeredSpawners = new ArrayList<CustomMobSpawner>();
    private final NamespacedKey customMobIdKey;

    public CustomMobRegistry(Plugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.customMobIdKey = new NamespacedKey(plugin, "custom_mob_id");
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        new BukkitRunnable(){

            public void run() {
                for (CustomMobGoalExecutor executor : CustomMobRegistry.this.goalExecutors.values()) {
                    executor.tick();
                }
            }
        }.runTaskTimer(plugin, 0L, 1L);
    }

    public void register(CustomMob customMob) {
        if (this.registeredCustomMobs.containsKey(customMob.getId())) {
            this.logger.warning("Custom mob with ID '" + customMob.getId() + "' already registered. Skipping.");
            return;
        }
        this.registeredCustomMobs.put(customMob.getId(), customMob);
        this.logger.info("Registered custom mob: " + customMob.getId() + " (based on " + customMob.getBaseType().name() + ")");
    }

    public void registerSpawner(CustomMobSpawner spawner) {
        this.registeredSpawners.add(spawner);
        this.logger.info("Registered custom mob spawner: " + spawner.getClass().getName());
    }

    public CustomMob getCustomMob(String id) {
        return this.registeredCustomMobs.get(id);
    }

    public Entity spawn(String customMobId, Location location) {
        CustomMob customMob = this.getCustomMob(customMobId);
        if (customMob == null) {
            this.logger.warning("Custom mob with ID '" + customMobId + "' not found. Cannot spawn.");
            return null;
        }
        if (location.getWorld() == null) {
            this.logger.warning("Cannot spawn custom mob in a null world.");
            return null;
        }
        Entity entity = location.getWorld().spawnEntity(location, customMob.getBaseType());
        if (entity instanceof LivingEntity) {
            AttributeInstance speedAttribute;
            AttributeInstance damageAttribute;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.getPersistentDataContainer().set(this.customMobIdKey, PersistentDataType.STRING, (Object)customMobId);
            livingEntity.setCustomName(customMob.getName());
            livingEntity.setCustomNameVisible(true);
            AttributeInstance healthAttribute = livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (healthAttribute != null) {
                healthAttribute.setBaseValue(customMob.getMaxHealth());
                livingEntity.setHealth(customMob.getMaxHealth());
            }
            if ((damageAttribute = livingEntity.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE)) != null) {
                damageAttribute.setBaseValue(customMob.getAttackDamage());
            }
            if ((speedAttribute = livingEntity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED)) != null) {
                speedAttribute.setBaseValue(customMob.getMovementSpeed());
            }
            for (Map.Entry<Attribute, Double> entry : customMob.getCustomAttributes().entrySet()) {
                AttributeInstance attributeInstance = livingEntity.getAttribute(entry.getKey());
                if (attributeInstance == null) continue;
                attributeInstance.setBaseValue(entry.getValue().doubleValue());
            }
            this.goalExecutors.put(livingEntity, new CustomMobGoalExecutor(livingEntity, customMob.getGoals()));
            this.logger.info("Spawned custom mob: " + customMob.getId() + " at " + String.valueOf(livingEntity.getLocation()));
            return livingEntity;
        }
        this.logger.warning("Custom mob base type " + customMob.getBaseType().name() + " is not a LivingEntity. Cannot apply custom attributes.");
        return entity;
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        String customMobId;
        CustomMob customMob;
        LivingEntity entity = event.getEntity();
        PersistentDataContainer container = entity.getPersistentDataContainer();
        if (!container.has(this.customMobIdKey, PersistentDataType.STRING) || (customMob = this.getCustomMob(customMobId = (String)container.get(this.customMobIdKey, PersistentDataType.STRING))) != null) {
            // empty if block
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        World world = chunk.getWorld();
        Random random = new Random();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int highestY = world.getHighestBlockYAt(chunk.getX() * 16 + x, chunk.getZ() * 16 + z);
                Block spawnBlock = world.getBlockAt(chunk.getX() * 16 + x, highestY + 1, chunk.getZ() * 16 + z);
                for (CustomMobSpawner spawner : this.registeredSpawners) {
                    spawner.spawn(world, random, spawnBlock);
                }
            }
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        this.goalExecutors.remove(entity);
    }

    public void unregisterAll() {
        this.registeredCustomMobs.clear();
        this.goalExecutors.clear();
        this.registeredSpawners.clear();
        HandlerList.unregisterAll((Listener)this);
        this.logger.info("Unregistered all custom mob definitions and event listener.");
    }
}

