/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

public class CustomRecipeRegistry {
    private final Plugin plugin;
    private final Logger logger;
    private final List<Recipe> registeredRecipes = new ArrayList<Recipe>();

    public CustomRecipeRegistry(Plugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public void register(Recipe recipe) {
        Bukkit.addRecipe((Recipe)recipe);
        this.registeredRecipes.add(recipe);
        this.logger.info("Registered custom recipe: " + recipe.getResult().getType().name());
    }

    public void unregisterAll() {
        Iterator it = Bukkit.recipeIterator();
        while (it.hasNext()) {
            Recipe recipe = (Recipe)it.next();
            if (!this.registeredRecipes.contains(recipe)) continue;
            it.remove();
            this.logger.info("Unregistered custom recipe: " + recipe.getResult().getType().name());
        }
        this.registeredRecipes.clear();
    }
}

