/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.SimpleStructure;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class CustomStructureManager {
    private final JavaPlugin plugin;
    private final Map<String, SimpleStructure> loadedStructures = new HashMap<String, SimpleStructure>();

    public CustomStructureManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean loadStructure(String structureId, File structureFile) {
        if (this.loadedStructures.containsKey(structureId)) {
            this.plugin.getLogger().warning("Structure with ID '" + structureId + "' already loaded.");
            return false;
        }
        SimpleStructure simpleStructure = new SimpleStructure(new Vector(3, 3, 3));
        simpleStructure.setBlock(0, 0, 0, Material.STONE);
        simpleStructure.setBlock(1, 0, 0, Material.STONE);
        simpleStructure.setBlock(0, 0, 1, Material.STONE);
        simpleStructure.setBlock(1, 0, 1, Material.STONE);
        simpleStructure.setBlock(0, 1, 0, Material.COBBLESTONE);
        simpleStructure.setBlock(1, 1, 0, Material.COBBLESTONE);
        simpleStructure.setBlock(0, 1, 1, Material.COBBLESTONE);
        simpleStructure.setBlock(1, 1, 1, Material.COBBLESTONE);
        simpleStructure.setBlock(0, 2, 0, Material.OAK_FENCE);
        simpleStructure.setBlock(1, 2, 0, Material.OAK_FENCE);
        simpleStructure.setBlock(0, 2, 1, Material.OAK_FENCE);
        simpleStructure.setBlock(1, 2, 1, Material.OAK_FENCE);
        this.loadedStructures.put(structureId, simpleStructure);
        this.plugin.getLogger().info("Loaded placeholder structure: " + structureId);
        return true;
    }

    public boolean spawnStructure(String structureId, Location location, Random random, int rotation, boolean mirror, float integrity) {
        SimpleStructure structure = this.loadedStructures.get(structureId);
        if (structure == null) {
            this.plugin.getLogger().warning("Attempted to spawn unknown structure: " + structureId);
            return false;
        }
        World world = location.getWorld();
        if (world == null) {
            this.plugin.getLogger().warning("Cannot spawn structure, world is null for location: " + String.valueOf(location));
            return false;
        }
        for (Map.Entry<Vector, BlockData> entry : structure.getBlocks().entrySet()) {
            Vector relativePos = entry.getKey();
            BlockData blockData = entry.getValue();
            Location targetLocation = location.clone().add(relativePos.getX(), relativePos.getY(), relativePos.getZ());
            targetLocation.getBlock().setBlockData(blockData, false);
        }
        this.plugin.getLogger().info("Spawned structure '" + structureId + "' at " + String.valueOf(location.toVector()));
        return true;
    }
}

