/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.ModInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ModConfigManager {
    private final JavaPlugin plugin;
    private final File configFolder;
    private final Map<String, YamlConfiguration> modConfigs = new HashMap<String, YamlConfiguration>();

    public ModConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.configFolder = new File(plugin.getDataFolder(), "configs");
        if (!this.configFolder.exists()) {
            this.configFolder.mkdirs();
        }
    }

    public YamlConfiguration getModConfig(String modId) {
        return this.modConfigs.get(modId);
    }

    public void loadModConfig(ModInfo modInfo) {
        File modConfigFile;
        block22: {
            File modConfigDir = new File(this.configFolder, modInfo.getName());
            if (!modConfigDir.exists()) {
                modConfigDir.mkdirs();
            }
            if (!(modConfigFile = new File(modConfigDir, "config.yml")).exists()) {
                try (InputStream defaultConfigFileStream = modInfo.getClassLoader().getResourceAsStream("config.yml");){
                    if (defaultConfigFileStream != null) {
                        try (FileOutputStream fos = new FileOutputStream(modConfigFile);){
                            int bytesRead;
                            byte[] buffer = new byte[4096];
                            while ((bytesRead = defaultConfigFileStream.read(buffer)) != -1) {
                                fos.write(buffer, 0, bytesRead);
                            }
                        }
                        this.plugin.getLogger().info("Extracted default config for mod: " + modInfo.getName());
                        break block22;
                    }
                    this.plugin.getLogger().info("Mod " + modInfo.getName() + " does not have a default config.yml.");
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to extract default config for mod: " + modInfo.getName(), e);
                }
            }
        }
        YamlConfiguration config = new YamlConfiguration();
        if (modConfigFile.exists()) {
            try {
                config.load(modConfigFile);
                this.modConfigs.put(modInfo.getName(), config);
                this.plugin.getLogger().info("Loaded config for mod: " + modInfo.getName());
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load config for mod: " + modInfo.getName(), e);
            }
        } else {
            this.modConfigs.put(modInfo.getName(), config);
            this.plugin.getLogger().info("No config file found for mod: " + modInfo.getName() + ". Using empty configuration.");
        }
    }

    public void saveModConfig(String modId) {
        YamlConfiguration config = this.modConfigs.get(modId);
        if (config != null) {
            File modConfigFile = new File(this.configFolder, modId + File.separator + "config.yml");
            try {
                config.save(modConfigFile);
                this.plugin.getLogger().info("Saved config for mod: " + modId);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to save config for mod: " + modId, e);
            }
        }
    }

    public void unloadModConfig(String modId) {
        this.modConfigs.remove(modId);
        this.plugin.getLogger().info("Unloaded config for mod: " + modId);
    }
}

