/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.AssetManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourcePackGenerator {
    private final JavaPlugin plugin;
    private final File stagingDir;
    private final File zipFile;
    private final AssetManager assetManager;
    private String zipFileSha1;

    public ResourcePackGenerator(JavaPlugin plugin, AssetManager assetManager) {
        this.plugin = plugin;
        this.assetManager = assetManager;
        this.stagingDir = new File(plugin.getDataFolder(), "resource-pack-staging");
        this.zipFile = new File(plugin.getDataFolder(), "generated-pack.zip");
    }

    public boolean generate() {
        try {
            if (!this.stagingDir.exists()) {
                this.stagingDir.mkdirs();
            }
            this.createPackMeta();
            this.addCustomAssets();
            this.zipDirectory(this.stagingDir, this.zipFile);
            this.zipFileSha1 = this.calculateSha1(this.zipFile);
            this.plugin.getLogger().info("Generated resource pack with SHA-1: " + this.zipFileSha1);
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to generate resource pack zip.");
            e.printStackTrace();
            return false;
        }
    }

    private void addCustomAssets() throws IOException {
        this.plugin.getLogger().info("Adding custom assets to resource pack staging directory.");
        for (File assetFile : this.assetManager.getAllStagedAssets().values()) {
            File relativePath = new File(this.stagingDir.toURI().relativize(assetFile.toURI()).getPath());
            File targetFile = new File(this.stagingDir, relativePath.getPath());
            targetFile.getParentFile().mkdirs();
            try (FileInputStream in = new FileInputStream(assetFile);
                 FileOutputStream out = new FileOutputStream(targetFile);){
                int length;
                byte[] buffer = new byte[4096];
                while ((length = in.read(buffer)) > 0) {
                    out.write(buffer, 0, length);
                }
                this.plugin.getLogger().info("Copied staged asset: " + assetFile.getName());
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to copy staged asset " + assetFile.getName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void copyFolder(File sourceFolder, File targetFolder) throws IOException {
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        for (String f : sourceFolder.list()) {
            File srcFile = new File(sourceFolder, f);
            File destFile = new File(targetFolder, f);
            if (srcFile.isDirectory()) {
                this.copyFolder(srcFile, destFile);
                continue;
            }
            String fileName = srcFile.getName().toLowerCase();
            if (!fileName.endsWith(".png") && !fileName.endsWith(".json") && !fileName.endsWith(".ogg")) continue;
            try (FileInputStream in = new FileInputStream(srcFile);
                 FileOutputStream out = new FileOutputStream(destFile);){
                int length;
                byte[] buffer = new byte[4096];
                while ((length = in.read(buffer)) > 0) {
                    out.write(buffer, 0, length);
                }
                this.plugin.getLogger().info("Copied asset: " + srcFile.getName());
                if (!fileName.endsWith(".json")) continue;
                this.validateJsonFile(destFile);
            }
        }
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public String getZipFileSha1() {
        return this.zipFileSha1;
    }

    private void createPackMeta() throws IOException {
        File packMetaFile = new File(this.stagingDir, "pack.mcmeta");
        try (FileWriter writer = new FileWriter(packMetaFile);){
            writer.write("{\n");
            writer.write("  \"pack\": {\n");
            writer.write("    \"pack_format\": 34,\n");
            writer.write("    \"description\": \"Dynamically generated server resources.\"\n");
            writer.write("  }\n");
            writer.write("}\n");
        }
        this.plugin.getLogger().info("Created pack.mcmeta file.");
    }

    private void zipDirectory(File dir, File zipFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            this.addDirToZip(dir, "", zos);
        }
        this.plugin.getLogger().info("Successfully zipped resource pack to: " + zipFile.getPath());
    }

    private void copyResource(String resourcePath, File targetFile) throws IOException {
        try (InputStream in = this.plugin.getResource(resourcePath);
             FileOutputStream out = new FileOutputStream(targetFile);){
            int length;
            if (in == null) {
                throw new IOException("Resource not found: " + resourcePath);
            }
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
        }
    }

    private void addDirToZip(File dir, String baseName, ZipOutputStream zos) throws IOException {
        File[] files = dir.listFiles();
        byte[] buffer = new byte[4096];
        for (File file : files) {
            if (file.isDirectory()) {
                this.addDirToZip(file, baseName + file.getName() + "/", zos);
                continue;
            }
            try (FileInputStream fis = new FileInputStream(file);){
                int length;
                zos.putNextEntry(new ZipEntry(baseName + file.getName()));
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String calculateSha1(File file) throws IOException {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            try (FileInputStream fis = new FileInputStream(file);){
                String string;
                try (DigestInputStream dis = new DigestInputStream(fis, sha1);){
                    while (dis.read() != -1) {
                    }
                    byte[] hash = sha1.digest();
                    StringBuilder hexString = new StringBuilder();
                    for (byte b : hash) {
                        hexString.append(String.format("%02x", b));
                    }
                    string = hexString.toString();
                }
                return string;
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to calculate SHA-1 hash.", e);
        }
    }

    private boolean validateJsonFile(File jsonFile) {
        boolean bl;
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        try {
            String line;
            StringBuilder jsonContent = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                jsonContent.append(line);
            }
            new JSONObject(jsonContent.toString());
            this.plugin.getLogger().info("Validated JSON file: " + jsonFile.getName());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JSONException e) {
                this.plugin.getLogger().warning("Invalid JSON syntax in file: " + jsonFile.getName() + ": " + e.getMessage());
                return false;
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Error reading JSON file: " + jsonFile.getName() + ": " + e.getMessage());
                return false;
            }
        }
        reader.close();
        return bl;
    }
}

