/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import org.bukkit.plugin.java.JavaPlugin;

public class WebServer {
    private final JavaPlugin plugin;
    private final File resourcePackFile;
    private final int port;
    private HttpServer server;
    private String resourcePackUrl;

    public WebServer(JavaPlugin plugin, File resourcePackFile, int port) {
        this.plugin = plugin;
        this.resourcePackFile = resourcePackFile;
        this.port = port;
    }

    public void start() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            this.server.createContext("/pack.zip", httpExchange -> {
                if (!this.resourcePackFile.exists()) {
                    String response = "404 (Not Found)\n";
                    httpExchange.sendResponseHeaders(404, response.length());
                    try (OutputStream os = httpExchange.getResponseBody();){
                        os.write(response.getBytes());
                    }
                    return;
                }
                httpExchange.sendResponseHeaders(200, this.resourcePackFile.length());
                try (OutputStream os = httpExchange.getResponseBody();){
                    Files.copy(this.resourcePackFile.toPath(), os);
                }
            });
            this.server.setExecutor(null);
            this.server.start();
            String address = this.plugin.getServer().getIp();
            if (address == null || address.isEmpty() || address.equals("0.0.0.0")) {
                address = "127.0.0.1";
            }
            this.resourcePackUrl = "http://" + address + ":" + this.port + "/pack.zip";
            this.plugin.getLogger().info("Web server started on port " + this.port);
            this.plugin.getLogger().info("Resource pack is available at: " + this.resourcePackUrl);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to start web server on port " + this.port);
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
            this.plugin.getLogger().info("Web server stopped.");
        }
    }

    public String getResourcePackUrl() {
        return this.resourcePackUrl;
    }
}

