/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api;

import com.example.modloader.AssetManager;
import com.example.modloader.api.CustomAssetAPI;
import java.io.File;
import java.net.URLClassLoader;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomAssetAPIImpl
implements CustomAssetAPI {
    private final JavaPlugin plugin;
    private final String modId;
    private final URLClassLoader modClassLoader;
    private final AssetManager assetManager;

    public CustomAssetAPIImpl(JavaPlugin plugin, String modId, URLClassLoader modClassLoader, AssetManager assetManager) {
        this.plugin = plugin;
        this.modId = modId;
        this.modClassLoader = modClassLoader;
        this.assetManager = assetManager;
    }

    @Override
    public void registerSound(String assetId, String soundFilePath) {
        this.assetManager.registerAsset(this.modId, assetId, soundFilePath, "sounds", this.modClassLoader);
    }

    @Override
    public void registerModel(String assetId, String modelFilePath) {
        this.assetManager.registerAsset(this.modId, assetId, modelFilePath, "models", this.modClassLoader);
    }

    @Override
    public void registerTexture(String assetId, String textureFilePath) {
        this.assetManager.registerAsset(this.modId, assetId, textureFilePath, "textures", this.modClassLoader);
    }

    @Override
    public File getAssetFile(String assetId) {
        return this.assetManager.getAllStagedAssets().get(assetId);
    }
}

