/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api;

import com.example.modloader.CustomEnchantment;
import com.example.modloader.api.CustomEnchantmentAPI;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomEnchantmentAPIImpl
implements CustomEnchantmentAPI {
    private final JavaPlugin plugin;
    private final Map<String, CustomEnchantment> registeredEnchantments = new HashMap<String, CustomEnchantment>();

    public CustomEnchantmentAPIImpl(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean registerEnchantment(CustomEnchantment enchantment) {
        if (this.registeredEnchantments.containsKey(enchantment.getKey().getKey())) {
            this.plugin.getLogger().warning("Attempted to register enchantment with duplicate key: " + enchantment.getKey().getKey());
            return false;
        }
        if (Enchantment.getByKey((NamespacedKey)enchantment.getKey()) != null) {
            this.plugin.getLogger().warning("Attempted to register enchantment with key that conflicts with a vanilla enchantment: " + enchantment.getKey().getKey());
            return false;
        }
        try {
            Field keyField = Enchantment.class.getDeclaredField("byKey");
            keyField.setAccessible(true);
            Map byKey = (Map)keyField.get(null);
            byKey.put(enchantment.getKey(), enchantment);
            Field nameField = Enchantment.class.getDeclaredField("byName");
            nameField.setAccessible(true);
            Map byName = (Map)nameField.get(null);
            byName.put(enchantment.getName(), enchantment);
            this.registeredEnchantments.put(enchantment.getKey().getKey(), enchantment);
            this.plugin.getLogger().info("Registered custom enchantment: " + enchantment.getName() + " (" + enchantment.getKey().getKey() + ")");
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to register custom enchantment: " + enchantment.getName(), e);
            return false;
        }
    }

    @Override
    public CustomEnchantment getEnchantment(String namespace) {
        return this.registeredEnchantments.get(namespace);
    }

    @Override
    public CustomEnchantment getEnchantmentByName(String name) {
        for (CustomEnchantment enchantment : this.registeredEnchantments.values()) {
            if (!enchantment.getName().equalsIgnoreCase(name)) continue;
            return enchantment;
        }
        return null;
    }

    public void unregisterAll() {
        try {
            Field keyField = Enchantment.class.getDeclaredField("byKey");
            keyField.setAccessible(true);
            Map byKey = (Map)keyField.get(null);
            Field nameField = Enchantment.class.getDeclaredField("byName");
            nameField.setAccessible(true);
            Map byName = (Map)nameField.get(null);
            for (CustomEnchantment enchantment : this.registeredEnchantments.values()) {
                byKey.remove(enchantment.getKey());
                byName.remove(enchantment.getName());
                this.plugin.getLogger().info("Unregistered custom enchantment: " + enchantment.getName());
            }
            this.registeredEnchantments.clear();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to unregister custom enchantments.", e);
        }
    }
}

