/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api.dependencyinjection;

import com.example.modloader.api.dependencyinjection.Binder;
import com.example.modloader.api.dependencyinjection.ModAPIRegistry;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class ModInjector {
    private final Binder binder;
    private final ModAPIRegistry apiRegistry;

    public ModInjector(Binder binder, ModAPIRegistry apiRegistry) {
        this.binder = binder;
        this.apiRegistry = apiRegistry;
    }

    public <T> T createInstance(Class<T> type) throws Exception {
        Constructor<?>[] constructors = type.getConstructors();
        if (constructors.length == 0) {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        Constructor<?> constructor = constructors[0];
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        ArrayList parameters = new ArrayList();
        for (Class<?> parameterType : parameterTypes) {
            if (this.binder.hasBinding(parameterType)) {
                parameters.add(this.binder.getInstance(parameterType));
                continue;
            }
            if (this.apiRegistry.hasAPI(parameterType)) {
                parameters.add(this.apiRegistry.getAPI(parameterType));
                continue;
            }
            throw new Exception("No binding found for type: " + parameterType.getName());
        }
        return (T)constructor.newInstance(parameters.toArray());
    }
}

