/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api.event;

import com.example.modloader.api.event.ModEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class EventBus {
    private final Map<Class<? extends ModEvent>, List<Consumer<? extends ModEvent>>> listeners = new HashMap<Class<? extends ModEvent>, List<Consumer<? extends ModEvent>>>();

    public <T extends ModEvent> void register(Class<T> eventType, Consumer<T> listener) {
        this.listeners.computeIfAbsent(eventType, k -> new ArrayList()).add(listener);
    }

    public <T extends ModEvent> void post(T event) {
        List<Consumer<? extends ModEvent>> eventListeners = this.listeners.get(event.getClass());
        if (eventListeners != null) {
            for (Consumer<? extends ModEvent> listener : eventListeners) {
                listener.accept(event);
            }
        }
    }
}

