/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api.network;

import com.example.modloader.api.network.Packet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class Networking
implements PluginMessageListener {
    private final JavaPlugin plugin;
    private final String channel = "modloader:main";
    private final Map<Class<? extends Packet>, List<Consumer<? extends Packet>>> packetListeners = new HashMap<Class<? extends Packet>, List<Consumer<? extends Packet>>>();

    public Networking(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getMessenger().registerIncomingPluginChannel((Plugin)plugin, "modloader:main", (PluginMessageListener)this);
        plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)plugin, "modloader:main");
    }

    public <T extends Packet> void registerListener(Class<T> packetType, Consumer<T> listener) {
        this.packetListeners.computeIfAbsent(packetType, k -> new ArrayList()).add(listener);
    }

    public void sendPacket(Player player, Packet packet) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(packet);
            objectStream.flush();
            player.sendPluginMessage((Plugin)this.plugin, "modloader:main", byteStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (channel.equals(this.channel)) {
            try {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(message);
                ObjectInputStream objectStream = new ObjectInputStream(byteStream);
                Packet packet = (Packet)objectStream.readObject();
                List<Consumer<? extends Packet>> listeners = this.packetListeners.get(packet.getClass());
                if (listeners != null) {
                    for (Consumer<? extends Packet> listener : listeners) {
                        listener.accept(packet);
                    }
                }
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

