/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public class AssetManager {
    private final JavaPlugin plugin;
    private final File resourcePackStagingDir;
    private final Map<String, StagedAssetInfo> stagedAssets = new HashMap<String, StagedAssetInfo>();

    public AssetManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.resourcePackStagingDir = new File(plugin.getDataFolder(), "resource-pack-staging");
        if (!this.resourcePackStagingDir.exists()) {
            this.resourcePackStagingDir.mkdirs();
        }
    }

    public void registerAsset(String modId, String assetId, String assetPathInJar, URLClassLoader modClassLoader) {
        this.registerAsset(modId, assetId, assetPathInJar, modClassLoader, 0);
    }

    public void registerAsset(String modId, String assetId, String assetPathInJar, URLClassLoader modClassLoader, int priority) {
        String assetTypeFolder = this.getAssetTypeFolder(assetPathInJar);
        if (assetTypeFolder == null) {
            this.plugin.getLogger().warning("Mod " + modId + ": Could not determine asset type for '" + assetPathInJar + "'. Skipping asset '" + assetId + "'.");
            return;
        }
        this.registerAssetInternal(modId, assetId, assetPathInJar, assetTypeFolder, modClassLoader, priority);
    }

    private void registerAssetInternal(String modId, String assetId, String filePathInJar, String assetTypeFolder, URLClassLoader modClassLoader, int priority) {
        File modAssetDir;
        if (this.stagedAssets.containsKey(assetId)) {
            StagedAssetInfo existingAsset = this.stagedAssets.get(assetId);
            if (priority < existingAsset.priority) {
                this.plugin.getLogger().info("Mod " + modId + ": Asset with ID '" + assetId + "' already registered by mod " + existingAsset.modId + " with higher priority. Skipping.");
                return;
            }
            if (priority == existingAsset.priority) {
                this.plugin.getLogger().warning("Mod " + modId + ": Asset with ID '" + assetId + "' already registered by mod " + existingAsset.modId + " with same priority. Skipping new asset.");
                return;
            }
            this.plugin.getLogger().info("Mod " + modId + ": Asset with ID '" + assetId + "' overriding existing asset from mod " + existingAsset.modId + ".");
            if (existingAsset.stagedFile.exists()) {
                existingAsset.stagedFile.delete();
            }
        }
        if (!(modAssetDir = new File(this.resourcePackStagingDir, "assets" + File.separator + modId)).exists()) {
            modAssetDir.mkdirs();
        }
        File targetFile = new File(modAssetDir, assetTypeFolder + File.separator + filePathInJar);
        targetFile.getParentFile().mkdirs();
        try (InputStream is = modClassLoader.getResourceAsStream(filePathInJar);){
            if (is == null) {
                this.plugin.getLogger().warning("Mod " + modId + ": Asset file '" + filePathInJar + "' not found in mod JAR. Cannot register asset '" + assetId + "'.");
                return;
            }
            try (FileOutputStream fos = new FileOutputStream(targetFile);){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = is.read(buffer)) != -1) {
                    fos.write(buffer, 0, bytesRead);
                }
            }
            this.stagedAssets.put(assetId, new StagedAssetInfo(modId, assetId, targetFile, priority));
            this.plugin.getLogger().info("Mod " + modId + ": Registered asset '" + assetId + "' from '" + filePathInJar + "'. Staged to: " + targetFile.getAbsolutePath() + " with priority " + priority + ".");
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Mod " + modId + ": Failed to stage asset '" + assetId + "' from '" + filePathInJar + "'.", e);
        }
    }

    private String getAssetTypeFolder(String filePathInJar) {
        String pathWithoutPrefix;
        int firstSlash;
        if (filePathInJar.startsWith("assets/") && (firstSlash = (pathWithoutPrefix = filePathInJar.substring("assets/".length())).indexOf(47)) != -1) {
            return pathWithoutPrefix.substring(0, firstSlash);
        }
        String extension = this.getFileExtension(filePathInJar);
        if (extension.equalsIgnoreCase("png") || extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg") || extension.equalsIgnoreCase("gif")) {
            return "textures";
        }
        if (extension.equalsIgnoreCase("json")) {
            return "models";
        }
        if (extension.equalsIgnoreCase("ogg")) {
            return "sounds";
        }
        return null;
    }

    private String getFileExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return fileName.substring(dotIndex + 1);
    }

    public Map<String, File> getAllStagedAssets() {
        HashMap<String, File> assets = new HashMap<String, File>();
        this.stagedAssets.forEach((assetId, info) -> assets.put((String)assetId, info.stagedFile));
        return assets;
    }

    public File getResourcePackStagingDir() {
        return this.resourcePackStagingDir;
    }

    public void unregisterAllAssetsForMod(String modIdToUnregister) {
        this.stagedAssets.entrySet().removeIf(entry -> ((StagedAssetInfo)entry.getValue()).modId.equals(modIdToUnregister));
        File modAssetDir = new File(this.resourcePackStagingDir, "assets" + File.separator + modIdToUnregister);
        if (modAssetDir.exists()) {
            this.deleteDirectory(modAssetDir);
            this.plugin.getLogger().info("Cleaned up asset staging directory for mod: " + modIdToUnregister);
        }
    }

    private boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                this.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    private static class StagedAssetInfo {
        final String modId;
        final String assetId;
        final File stagedFile;
        final int priority;

        StagedAssetInfo(String modId, String assetId, File stagedFile, int priority) {
            this.modId = modId;
            this.assetId = assetId;
            this.stagedFile = stagedFile;
            this.priority = priority;
        }
    }
}

