/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.api.event.EventBus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class CustomEventListenerRegistry {
    private final Plugin plugin;
    private final Logger logger;
    private final PluginManager pluginManager;
    private final EventBus eventBus;
    private final Map<Object, String> registeredListenerMods = new HashMap<Object, String>();
    private final List<Object> registeredListeners = new ArrayList<Object>();

    public CustomEventListenerRegistry(Plugin plugin, EventBus eventBus) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.pluginManager = plugin.getServer().getPluginManager();
        this.eventBus = eventBus;
    }

    public void register(Object listener, String modId) {
        if (listener instanceof Listener) {
            this.pluginManager.registerEvents((Listener)listener, this.plugin);
        }
        this.eventBus.register(listener);
        this.registeredListeners.add(listener);
        this.registeredListenerMods.put(listener, modId);
        this.logger.info("Registered custom event listener: " + listener.getClass().getName() + " by mod " + modId);
    }

    public void unregisterAll(String modId) {
        ArrayList<Object> listenersToRemove = new ArrayList<Object>();
        for (Map.Entry<Object, String> entry : this.registeredListenerMods.entrySet()) {
            if (!entry.getValue().equals(modId)) continue;
            listenersToRemove.add(entry.getKey());
        }
        for (Map.Entry<Object, String> entry : listenersToRemove) {
            if (entry instanceof Listener) {
                HandlerList.unregisterAll((Listener)((Listener)entry));
            }
            this.eventBus.unregister(entry);
            this.registeredListeners.remove(entry);
            this.registeredListenerMods.remove(entry);
            this.logger.info("Unregistered custom event listener: " + entry.getClass().getName() + " from mod " + modId);
        }
    }

    public void unregisterAll() {
        for (Object listener : new ArrayList<Object>(this.registeredListeners)) {
            if (listener instanceof Listener) {
                HandlerList.unregisterAll((Listener)((Listener)listener));
            }
            this.eventBus.unregister(listener);
            this.logger.info("Unregistered custom event listener: " + listener.getClass().getName());
        }
        this.registeredListeners.clear();
        this.registeredListenerMods.clear();
    }
}

