/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.api.event.EventBus;
import com.example.modloader.api.event.PreRegisterItemEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CustomItemRegistry {
    private final Logger logger;
    private final Map<String, ItemStack> registeredItems = new HashMap<String, ItemStack>();
    private final EventBus eventBus;

    public CustomItemRegistry(Plugin plugin, EventBus eventBus) {
        this.logger = plugin.getLogger();
        this.eventBus = eventBus;
    }

    public void register(String itemId, ItemStack item) {
        PreRegisterItemEvent event = new PreRegisterItemEvent(itemId, item);
        this.eventBus.post(event);
        if (event.isCancelled()) {
            this.logger.warning("Custom item registration for '" + itemId + "' was cancelled by another mod. Skipping.");
            return;
        }
        if (this.registeredItems.containsKey(itemId)) {
            this.logger.warning("Custom item with ID '" + itemId + "' already registered. Skipping.");
            return;
        }
        this.registeredItems.put(itemId, item);
        this.logger.info("Registered custom item: " + itemId);
    }

    public ItemStack getItemStack(String id) {
        return this.registeredItems.get(id);
    }
}

