/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.api.CustomWorldPopulator;
import com.example.modloader.api.world.CustomOreGenerator;
import com.example.modloader.api.world.CustomStructureGenerator;
import com.example.modloader.api.world.CustomTreeGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.plugin.Plugin;

public class CustomWorldGeneratorRegistry {
    private final Plugin plugin;
    private final Logger logger;
    private final List<CustomWorldPopulator> globalPopulators = new ArrayList<CustomWorldPopulator>();
    private final List<CustomOreGenerator> globalOreGenerators = new ArrayList<CustomOreGenerator>();
    private final List<CustomTreeGenerator> globalTreeGenerators = new ArrayList<CustomTreeGenerator>();
    private final List<CustomStructureGenerator> globalStructureGenerators = new ArrayList<CustomStructureGenerator>();
    private final Map<String, List<CustomWorldPopulator>> worldSpecificPopulators = new HashMap<String, List<CustomWorldPopulator>>();
    private final Map<String, List<CustomOreGenerator>> worldSpecificOreGenerators = new HashMap<String, List<CustomOreGenerator>>();
    private final Map<String, List<CustomTreeGenerator>> worldSpecificTreeGenerators = new HashMap<String, List<CustomTreeGenerator>>();
    private final Map<String, List<CustomStructureGenerator>> worldSpecificStructureGenerators = new HashMap<String, List<CustomStructureGenerator>>();
    private final Map<Biome, List<CustomWorldPopulator>> biomeSpecificPopulators = new HashMap<Biome, List<CustomWorldPopulator>>();
    private final Map<Biome, List<CustomOreGenerator>> biomeSpecificOreGenerators = new HashMap<Biome, List<CustomOreGenerator>>();
    private final Map<Biome, List<CustomTreeGenerator>> biomeSpecificTreeGenerators = new HashMap<Biome, List<CustomTreeGenerator>>();
    private final Map<Biome, List<CustomStructureGenerator>> biomeSpecificStructureGenerators = new HashMap<Biome, List<CustomStructureGenerator>>();

    public CustomWorldGeneratorRegistry(Plugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public void registerPopulator(CustomWorldPopulator populator, String[] worldNames, Biome ... biomes) {
        if (worldNames != null && worldNames.length > 0) {
            for (String worldName : worldNames) {
                this.worldSpecificPopulators.computeIfAbsent(worldName, k -> new ArrayList()).add(populator);
                this.logger.info("Registered custom world populator for world '" + worldName + "': " + populator.getClass().getName());
            }
        } else if (biomes != null && biomes.length > 0) {
            for (Biome biome : biomes) {
                this.biomeSpecificPopulators.computeIfAbsent(biome, k -> new ArrayList()).add(populator);
                this.logger.info("Registered custom world populator for biome '" + biome.name() + "': " + populator.getClass().getName());
            }
        } else {
            this.globalPopulators.add(populator);
            this.logger.info("Registered global custom world populator: " + populator.getClass().getName());
        }
    }

    public void registerOreGenerator(CustomOreGenerator generator, String[] worldNames, Biome ... biomes) {
        if (worldNames != null && worldNames.length > 0) {
            for (String worldName : worldNames) {
                this.worldSpecificOreGenerators.computeIfAbsent(worldName, k -> new ArrayList()).add(generator);
                this.logger.info("Registered custom ore generator for world '" + worldName + "': " + generator.getClass().getName());
            }
        } else if (biomes != null && biomes.length > 0) {
            for (Biome biome : biomes) {
                this.biomeSpecificOreGenerators.computeIfAbsent(biome, k -> new ArrayList()).add(generator);
                this.logger.info("Registered custom ore generator for biome '" + biome.name() + "': " + generator.getClass().getName());
            }
        } else {
            this.globalOreGenerators.add(generator);
            this.logger.info("Registered global custom ore generator: " + generator.getClass().getName());
        }
    }

    public void registerTreeGenerator(CustomTreeGenerator generator, String[] worldNames, Biome ... biomes) {
        if (worldNames != null && worldNames.length > 0) {
            for (String worldName : worldNames) {
                this.worldSpecificTreeGenerators.computeIfAbsent(worldName, k -> new ArrayList()).add(generator);
                this.logger.info("Registered custom tree generator for world '" + worldName + "': " + generator.getClass().getName());
            }
        } else if (biomes != null && biomes.length > 0) {
            for (Biome biome : biomes) {
                this.biomeSpecificTreeGenerators.computeIfAbsent(biome, k -> new ArrayList()).add(generator);
                this.logger.info("Registered custom tree generator for biome '" + biome.name() + "': " + generator.getClass().getName());
            }
        } else {
            this.globalTreeGenerators.add(generator);
            this.logger.info("Registered global custom tree generator: " + generator.getClass().getName());
        }
    }

    public void registerStructureGenerator(CustomStructureGenerator generator, String[] worldNames, Biome ... biomes) {
        if (worldNames != null && worldNames.length > 0) {
            for (String worldName : worldNames) {
                this.worldSpecificStructureGenerators.computeIfAbsent(worldName, k -> new ArrayList()).add(generator);
                this.logger.info("Registered custom structure generator for world '" + worldName + "': " + generator.getClass().getName());
            }
        } else if (biomes != null && biomes.length > 0) {
            for (Biome biome : biomes) {
                this.biomeSpecificStructureGenerators.computeIfAbsent(biome, k -> new ArrayList()).add(generator);
                this.logger.info("Registered custom structure generator for biome '" + biome.name() + "': " + generator.getClass().getName());
            }
        } else {
            this.globalStructureGenerators.add(generator);
            this.logger.info("Registered global custom structure generator: " + generator.getClass().getName());
        }
    }

    public void applyPopulatorsToWorld(World world) {
        String worldName = world.getName();
        for (CustomWorldPopulator customWorldPopulator : this.globalPopulators) {
            world.getPopulators().add(new CustomWorldPopulatorBlockPopulator(customWorldPopulator));
            this.logger.info("Applied global populator " + customWorldPopulator.getClass().getName() + " to world " + worldName);
        }
        if (this.worldSpecificPopulators.containsKey(worldName)) {
            for (CustomWorldPopulator customWorldPopulator : this.worldSpecificPopulators.get(worldName)) {
                world.getPopulators().add(new CustomWorldPopulatorBlockPopulator(customWorldPopulator));
                this.logger.info("Applied world-specific populator " + customWorldPopulator.getClass().getName() + " to world " + worldName);
            }
        }
        world.getPopulators().add(new BiomeSpecificWorldPopulatorBlockPopulator(this.biomeSpecificPopulators));
        for (CustomOreGenerator customOreGenerator : this.globalOreGenerators) {
            world.getPopulators().add(new CustomOreGeneratorBlockPopulator(customOreGenerator));
        }
        if (this.worldSpecificOreGenerators.containsKey(worldName)) {
            for (CustomOreGenerator customOreGenerator : this.worldSpecificOreGenerators.get(worldName)) {
                world.getPopulators().add(new CustomOreGeneratorBlockPopulator(customOreGenerator));
            }
        }
        world.getPopulators().add(new BiomeSpecificOreGeneratorBlockPopulator(this.biomeSpecificOreGenerators));
        for (CustomTreeGenerator customTreeGenerator : this.globalTreeGenerators) {
            world.getPopulators().add(new CustomTreeGeneratorBlockPopulator(customTreeGenerator));
        }
        if (this.worldSpecificTreeGenerators.containsKey(worldName)) {
            for (CustomTreeGenerator customTreeGenerator : this.worldSpecificTreeGenerators.get(worldName)) {
                world.getPopulators().add(new CustomTreeGeneratorBlockPopulator(customTreeGenerator));
            }
        }
        world.getPopulators().add(new BiomeSpecificTreeGeneratorBlockPopulator(this.biomeSpecificTreeGenerators));
        for (CustomStructureGenerator customStructureGenerator : this.globalStructureGenerators) {
            world.getPopulators().add(new CustomStructureGeneratorBlockPopulator(customStructureGenerator));
        }
        if (this.worldSpecificStructureGenerators.containsKey(worldName)) {
            for (CustomStructureGenerator customStructureGenerator : this.worldSpecificStructureGenerators.get(worldName)) {
                world.getPopulators().add(new CustomStructureGeneratorBlockPopulator(customStructureGenerator));
            }
        }
        world.getPopulators().add(new BiomeSpecificStructureGeneratorBlockPopulator(this.biomeSpecificStructureGenerators));
    }

    public void unregisterAll() {
        this.globalPopulators.clear();
        this.worldSpecificPopulators.clear();
        this.biomeSpecificPopulators.clear();
        this.globalOreGenerators.clear();
        this.worldSpecificOreGenerators.clear();
        this.biomeSpecificOreGenerators.clear();
        this.globalTreeGenerators.clear();
        this.worldSpecificTreeGenerators.clear();
        this.biomeSpecificTreeGenerators.clear();
        this.globalStructureGenerators.clear();
        this.worldSpecificStructureGenerators.clear();
        this.biomeSpecificStructureGenerators.clear();
        this.logger.info("Unregistered all custom world populator, ore, tree, and structure generator definitions.");
    }

    private static class CustomWorldPopulatorBlockPopulator
    extends BlockPopulator {
        private final CustomWorldPopulator customPopulator;

        public CustomWorldPopulatorBlockPopulator(CustomWorldPopulator customPopulator) {
            this.customPopulator = customPopulator;
        }

        public void populate(World world, Random random, Chunk chunk) {
            this.customPopulator.populate(world, random, chunk);
        }
    }

    private static class BiomeSpecificWorldPopulatorBlockPopulator
    extends BlockPopulator {
        private final Map<Biome, List<CustomWorldPopulator>> biomeSpecificPopulators;

        public BiomeSpecificWorldPopulatorBlockPopulator(Map<Biome, List<CustomWorldPopulator>> biomeSpecificPopulators) {
            this.biomeSpecificPopulators = biomeSpecificPopulators;
        }

        public void populate(World world, Random random, Chunk chunk) {
            Biome chunkBiome = world.getBiome(chunk.getX() * 16 + 7, 7, chunk.getZ() * 16 + 7);
            if (this.biomeSpecificPopulators.containsKey(chunkBiome)) {
                for (CustomWorldPopulator customPopulator : this.biomeSpecificPopulators.get(chunkBiome)) {
                    customPopulator.populate(world, random, chunk);
                }
            }
        }
    }

    private static class CustomOreGeneratorBlockPopulator
    extends BlockPopulator {
        private final CustomOreGenerator generator;

        public CustomOreGeneratorBlockPopulator(CustomOreGenerator generator) {
            this.generator = generator;
        }

        public void populate(World world, Random random, Chunk chunk) {
            this.generator.generate(world, random, chunk.getX(), chunk.getZ());
        }
    }

    private static class BiomeSpecificOreGeneratorBlockPopulator
    extends BlockPopulator {
        private final Map<Biome, List<CustomOreGenerator>> biomeSpecificOreGenerators;

        public BiomeSpecificOreGeneratorBlockPopulator(Map<Biome, List<CustomOreGenerator>> biomeSpecificOreGenerators) {
            this.biomeSpecificOreGenerators = biomeSpecificOreGenerators;
        }

        public void populate(World world, Random random, Chunk chunk) {
            Biome chunkBiome = world.getBiome(chunk.getX() * 16 + 7, 7, chunk.getZ() * 16 + 7);
            if (this.biomeSpecificOreGenerators.containsKey(chunkBiome)) {
                for (CustomOreGenerator generator : this.biomeSpecificOreGenerators.get(chunkBiome)) {
                    generator.generate(world, random, chunk.getX(), chunk.getZ());
                }
            }
        }
    }

    private static class CustomTreeGeneratorBlockPopulator
    extends BlockPopulator {
        private final CustomTreeGenerator generator;

        public CustomTreeGeneratorBlockPopulator(CustomTreeGenerator generator) {
            this.generator = generator;
        }

        public void populate(World world, Random random, Chunk chunk) {
            int x = chunk.getX() * 16 + random.nextInt(16);
            int z = chunk.getZ() * 16 + random.nextInt(16);
            int y = world.getHighestBlockYAt(x, z);
            this.generator.generate(world, random, x, y, z);
        }
    }

    private static class BiomeSpecificTreeGeneratorBlockPopulator
    extends BlockPopulator {
        private final Map<Biome, List<CustomTreeGenerator>> biomeSpecificTreeGenerators;

        public BiomeSpecificTreeGeneratorBlockPopulator(Map<Biome, List<CustomTreeGenerator>> biomeSpecificTreeGenerators) {
            this.biomeSpecificTreeGenerators = biomeSpecificTreeGenerators;
        }

        public void populate(World world, Random random, Chunk chunk) {
            Biome chunkBiome = world.getBiome(chunk.getX() * 16 + 7, 7, chunk.getZ() * 16 + 7);
            if (this.biomeSpecificTreeGenerators.containsKey(chunkBiome)) {
                for (CustomTreeGenerator generator : this.biomeSpecificTreeGenerators.get(chunkBiome)) {
                    int x = chunk.getX() * 16 + random.nextInt(16);
                    int z = chunk.getZ() * 16 + random.nextInt(16);
                    int y = world.getHighestBlockYAt(x, z);
                    generator.generate(world, random, x, y, z);
                }
            }
        }
    }

    private static class CustomStructureGeneratorBlockPopulator
    extends BlockPopulator {
        private final CustomStructureGenerator generator;

        public CustomStructureGeneratorBlockPopulator(CustomStructureGenerator generator) {
            this.generator = generator;
        }

        public void populate(World world, Random random, Chunk chunk) {
            this.generator.generate(world, random, chunk.getX(), chunk.getZ());
        }
    }

    private static class BiomeSpecificStructureGeneratorBlockPopulator
    extends BlockPopulator {
        private final Map<Biome, List<CustomStructureGenerator>> biomeSpecificStructureGenerators;

        public BiomeSpecificStructureGeneratorBlockPopulator(Map<Biome, List<CustomStructureGenerator>> biomeSpecificStructureGenerators) {
            this.biomeSpecificStructureGenerators = biomeSpecificStructureGenerators;
        }

        public void populate(World world, Random random, Chunk chunk) {
            Biome chunkBiome = world.getBiome(chunk.getX() * 16 + 7, 7, chunk.getZ() * 16 + 7);
            if (this.biomeSpecificStructureGenerators.containsKey(chunkBiome)) {
                for (CustomStructureGenerator generator : this.biomeSpecificStructureGenerators.get(chunkBiome)) {
                    generator.generate(world, random, chunk.getX(), chunk.getZ());
                }
            }
        }
    }
}

