/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.ModInfo;
import com.example.modloader.ModRepository;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.net.httpserver.HttpExchange;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Marketplace {
    private final ModRepository modRepository;
    private final File modsDir;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Marketplace(ModRepository modRepository, File modsDir) {
        this.modRepository = modRepository;
        this.modsDir = modsDir;
    }

    public void handleGetMods(HttpExchange httpExchange) throws IOException {
        List<ModInfo> repoMods = this.modRepository.getAllMods();
        String jsonResponse = this.gson.toJson(repoMods);
        httpExchange.getResponseHeaders().set("Content-Type", "application/json");
        httpExchange.sendResponseHeaders(200, jsonResponse.length());
        try (OutputStream os = httpExchange.getResponseBody();){
            os.write(jsonResponse.getBytes());
        }
    }

    public void handleDownloadMod(HttpExchange httpExchange) throws IOException {
        String path = httpExchange.getRequestURI().getPath();
        String[] pathParts = path.split("/");
        if (pathParts.length < 4) {
            httpExchange.sendResponseHeaders(400, -1L);
            return;
        }
        String modId = pathParts[3];
        Optional<File> modFile = this.findModFile(modId);
        if (modFile.isPresent()) {
            File file = modFile.get();
            httpExchange.getResponseHeaders().set("Content-Type", "application/java-archive");
            httpExchange.getResponseHeaders().set("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
            httpExchange.sendResponseHeaders(200, file.length());
            try (OutputStream os = httpExchange.getResponseBody();){
                Files.copy(file.toPath(), os);
            }
        } else {
            httpExchange.sendResponseHeaders(404, -1L);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<File> findModFile(String modId) {
        File[] files = this.modsDir.listFiles((dir, name) -> name.endsWith(".modloader999"));
        if (files == null) {
            return Optional.empty();
        }
        File[] fileArray = files;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                File file = fileArray[n2];
                try (JarFile jarFile = new JarFile(file);){
                    JarEntry modInfoEntry = jarFile.getJarEntry("modinfo.json");
                    if (modInfoEntry == null) break block17;
                    try (InputStream is = jarFile.getInputStream(modInfoEntry);){
                        JsonNode modInfoJson = this.objectMapper.readTree(is);
                        if (modInfoJson.has("id") && modId.equals(modInfoJson.get("id").asText())) {
                            Optional<File> optional = Optional.of(file);
                            return optional;
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return Optional.empty();
    }
}

