/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.ModInfo;
import com.example.modloader.api.config.ConfigChangeListener;
import com.example.modloader.api.config.ConfigProperty;
import com.example.modloader.api.config.ModConfig;
import com.example.modloader.api.config.ModConfigProvider;
import com.example.modloader.config.ConfigurationSource;
import com.example.modloader.config.YamlConfigurationSource;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ModConfigManager {
    private final JavaPlugin plugin;
    private final File configFolder;
    private final Map<String, ModConfig> modConfigs = new ConcurrentHashMap<String, ModConfig>();
    private final Map<String, ConfigChangeListener<ModConfig>> configChangeListeners = new ConcurrentHashMap<String, ConfigChangeListener<ModConfig>>();
    private final Map<String, File> modConfigFiles = new ConcurrentHashMap<String, File>();
    private final Map<String, Long> lastModifiedTimes = new ConcurrentHashMap<String, Long>();
    private BukkitRunnable configWatcherTask;
    private final ConfigurationSource configSource;

    public ModConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.configFolder = new File(plugin.getDataFolder(), "configs");
        if (!this.configFolder.exists()) {
            this.configFolder.mkdirs();
        }
        this.configSource = new YamlConfigurationSource();
        this.startConfigWatcher();
    }

    public <T extends ModConfig> T getModConfig(String modId, Class<T> configClass) {
        this.plugin.getLogger().info("Attempting to retrieve config for modId: " + modId);
        ModConfig config = this.modConfigs.get(modId);
        if (config == null) {
            this.plugin.getLogger().warning("Config for modId: " + modId + " not found in modConfigs map.");
        } else {
            this.plugin.getLogger().info("Config for modId: " + modId + " found. Type: " + config.getClass().getName());
        }
        return (T)((ModConfig)configClass.cast(config));
    }

    public <T extends ModConfig> void registerConfigChangeListener(String modId, ConfigChangeListener<T> listener) {
        this.configChangeListeners.put(modId, listener);
    }

    public void loadModConfig(ModInfo modInfo) {
        File modConfigFile;
        block32: {
            File modConfigDir = new File(this.configFolder, modInfo.getId());
            if (!modConfigDir.exists()) {
                modConfigDir.mkdirs();
            }
            modConfigFile = new File(modConfigDir, "config.yml");
            this.modConfigFiles.put(modInfo.getId(), modConfigFile);
            if (!modConfigFile.exists()) {
                try (InputStream defaultConfigFileStream = modInfo.getClassLoader().getResourceAsStream("config.yml");){
                    if (defaultConfigFileStream != null) {
                        try (FileOutputStream fos = new FileOutputStream(modConfigFile);){
                            int bytesRead;
                            byte[] buffer = new byte[4096];
                            while ((bytesRead = defaultConfigFileStream.read(buffer)) != -1) {
                                fos.write(buffer, 0, bytesRead);
                            }
                        }
                        this.plugin.getLogger().info("Extracted default config for mod: " + modInfo.getName());
                        break block32;
                    }
                    this.plugin.getLogger().info("Mod " + modInfo.getName() + " does not have a default config.yml.");
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to extract default config for mod: " + modInfo.getName(), e);
                }
            }
        }
        JsonNode rootNode = null;
        if (modConfigFile.exists()) {
            try (FileInputStream is = new FileInputStream(modConfigFile);){
                rootNode = this.configSource.load(is);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load config file for mod: " + modInfo.getName(), e);
                return;
            }
        }
        try {
            ModConfig modConfigInstance = null;
            this.plugin.getLogger().info("Searching for @ModConfigProvider in mod: " + modInfo.getName());
            for (Method method : modInfo.getInitializer().getClass().getMethods()) {
                if (!method.isAnnotationPresent(ModConfigProvider.class) || !ModConfig.class.isAssignableFrom(method.getReturnType())) continue;
                this.plugin.getLogger().info("Found @ModConfigProvider method: " + method.getName() + " in mod: " + modInfo.getName());
                if (Modifier.isStatic(method.getModifiers())) {
                    this.plugin.getLogger().info("Invoked static @ModConfigProvider method for mod: " + modInfo.getName());
                    break;
                }
                this.plugin.getLogger().info("Invoked instance @ModConfigProvider method for mod: " + modInfo.getName());
                break;
            }
            if (modConfigInstance != null) {
                this.plugin.getLogger().info("ModConfig instance created for mod: " + modInfo.getName());
                this.loadConfigFromJsonNode(modConfigInstance, rootNode);
                this.modConfigs.put(modInfo.getId(), modConfigInstance);
                this.plugin.getLogger().info("Config for modId: " + modInfo.getId() + " successfully added to modConfigs map.");
                this.lastModifiedTimes.put(modInfo.getId(), modConfigFile.lastModified());
                this.plugin.getLogger().info("Loaded type-safe config for mod: " + modInfo.getName());
            } else {
                this.plugin.getLogger().warning("Mod " + modInfo.getName() + " does not provide a type-safe config. Using raw YAML.");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to process type-safe config for mod: " + modInfo.getName(), e);
        }
    }

    private void loadConfigFromJsonNode(ModConfig configInstance, JsonNode jsonNode) throws IllegalAccessException {
        if (jsonNode == null) {
            return;
        }
        for (Field field : configInstance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigProperty.class)) continue;
            field.setAccessible(true);
            ConfigProperty configProperty = field.getAnnotation(ConfigProperty.class);
            String path = configProperty.path();
            if (path.isEmpty()) {
                path = field.getName();
            }
            JsonNode valueNode = jsonNode.get(path);
            if (configProperty.required() && valueNode == null && configProperty.defaultValue().isEmpty()) {
                this.plugin.getLogger().warning("Required config property '" + path + "' for mod config is missing and no default value is provided.");
                continue;
            }
            if (valueNode == null || valueNode.isNull()) {
                if (configProperty.defaultValue().isEmpty()) continue;
                try {
                    Object defaultValue = this.parseDefaultValue(configProperty.defaultValue(), field.getType());
                    field.set(configInstance, defaultValue);
                    this.plugin.getLogger().info("Using default value for '" + path + "': " + configProperty.defaultValue());
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to parse default value '" + configProperty.defaultValue() + "' for field '" + field.getName() + "'.", e);
                }
                continue;
            }
            try {
                if (field.getType() == String.class) {
                    String value = valueNode.asText();
                    if (!configProperty.pattern().isEmpty() && !value.matches(configProperty.pattern())) {
                        this.plugin.getLogger().warning("Config property '" + path + "' does not match required pattern: " + configProperty.pattern());
                        continue;
                    }
                    if (configProperty.allowedValues().length > 0 && !Arrays.asList(configProperty.allowedValues()).contains(value)) {
                        this.plugin.getLogger().warning("Config property '" + path + "' has an invalid value. Allowed values: " + Arrays.toString(configProperty.allowedValues()));
                        continue;
                    }
                    field.set(configInstance, value);
                    continue;
                }
                if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                    int value = valueNode.asInt();
                    if ((double)value < configProperty.minValue() || (double)value > configProperty.maxValue()) {
                        this.plugin.getLogger().warning("Config property '" + path + "' is out of range. Min: " + configProperty.minValue() + ", Max: " + configProperty.maxValue());
                        continue;
                    }
                    field.set(configInstance, value);
                    continue;
                }
                if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                    field.set(configInstance, valueNode.asBoolean());
                    continue;
                }
                if (field.getType() == Double.TYPE || field.getType() == Double.class) {
                    double value = valueNode.asDouble();
                    if (value < configProperty.minValue() || value > configProperty.maxValue()) {
                        this.plugin.getLogger().warning("Config property '" + path + "' is out of range. Min: " + configProperty.minValue() + ", Max: " + configProperty.maxValue());
                        continue;
                    }
                    field.set(configInstance, value);
                    continue;
                }
                if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                    long value = valueNode.asLong();
                    if ((double)value < configProperty.minValue() || (double)value > configProperty.maxValue()) {
                        this.plugin.getLogger().warning("Config property '" + path + "' is out of range. Min: " + configProperty.minValue() + ", Max: " + configProperty.maxValue());
                        continue;
                    }
                    field.set(configInstance, value);
                    continue;
                }
                this.plugin.getLogger().warning("Unsupported config type for field '" + field.getName() + "' in mod config. Path: " + path);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error setting config property '" + path + "' for field '" + field.getName() + "'.", e);
            }
        }
    }

    private Object parseDefaultValue(String defaultValue, Class<?> type) {
        if (type == String.class) {
            return defaultValue;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(defaultValue);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(defaultValue);
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(defaultValue);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(defaultValue);
        }
        throw new IllegalArgumentException("Unsupported type for default value parsing: " + type.getName());
    }

    public void saveModConfig(String modId) {
        ModConfig configInstance = this.modConfigs.get(modId);
        if (configInstance != null) {
            File modConfigFile = this.modConfigFiles.get(modId);
            if (modConfigFile == null) {
                this.plugin.getLogger().warning("Config file not found for mod: " + modId + ". Cannot save.");
                return;
            }
            ObjectMapper objectMapper = new ObjectMapper(new YAMLFactory());
            ObjectNode rootNode = objectMapper.createObjectNode();
            this.saveConfigToJsonNode(configInstance, rootNode);
            try (FileOutputStream os = new FileOutputStream(modConfigFile);){
                this.configSource.save(rootNode, os);
                this.lastModifiedTimes.put(modId, modConfigFile.lastModified());
                this.plugin.getLogger().info("Saved type-safe config for mod: " + modId);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to save type-safe config for mod: " + modId, e);
            }
        }
    }

    public void unloadModConfig(String modId) {
        this.modConfigs.remove(modId);
        this.configChangeListeners.remove(modId);
        this.modConfigFiles.remove(modId);
        this.lastModifiedTimes.remove(modId);
        this.plugin.getLogger().info("Unloaded config for mod: " + modId);
    }

    private void saveConfigToJsonNode(ModConfig configInstance, ObjectNode objectNode) {
        for (Field field : configInstance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigProperty.class)) continue;
            field.setAccessible(true);
            ConfigProperty configProperty = field.getAnnotation(ConfigProperty.class);
            String path = configProperty.path();
            if (path.isEmpty()) {
                path = field.getName();
            }
            try {
                Object value = field.get(configInstance);
                if (value == null) continue;
                if (value instanceof String) {
                    objectNode.put(path, (String)value);
                    continue;
                }
                if (value instanceof Integer) {
                    objectNode.put(path, (Integer)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    objectNode.put(path, (Boolean)value);
                    continue;
                }
                if (value instanceof Double) {
                    objectNode.put(path, (Double)value);
                    continue;
                }
                if (value instanceof Long) {
                    objectNode.put(path, (Long)value);
                    continue;
                }
                this.plugin.getLogger().warning("Unsupported config type for saving field '" + field.getName() + "'. Skipping. Path: " + path);
            }
            catch (IllegalAccessException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to access field '" + field.getName() + "' for saving config.", e);
            }
        }
    }

    private void startConfigWatcher() {
        this.configWatcherTask = new BukkitRunnable(){

            public void run() {
                for (Map.Entry<String, File> entry : ModConfigManager.this.modConfigFiles.entrySet()) {
                    String modId = entry.getKey();
                    File configFile = entry.getValue();
                    long currentLastModified = configFile.lastModified();
                    if (!ModConfigManager.this.lastModifiedTimes.containsKey(modId) || currentLastModified <= ModConfigManager.this.lastModifiedTimes.get(modId)) continue;
                    ModConfigManager.this.plugin.getLogger().info("Config file for mod '" + modId + "' changed. Reloading...");
                    JsonNode rootNode = null;
                    ModConfig existingConfig = ModConfigManager.this.modConfigs.get(modId);
                    if (existingConfig == null) continue;
                    try (FileInputStream is = new FileInputStream(configFile);){
                        rootNode = ModConfigManager.this.configSource.load(is);
                        ModConfigManager.this.loadConfigFromJsonNode(existingConfig, rootNode);
                        ModConfigManager.this.lastModifiedTimes.put(modId, currentLastModified);
                        ConfigChangeListener<ModConfig> listener = ModConfigManager.this.configChangeListeners.get(modId);
                        if (listener != null) {
                            listener.onConfigChanged(existingConfig);
                        }
                        ModConfigManager.this.plugin.getLogger().info("Config for mod '" + modId + "' reloaded and listener notified.");
                    }
                    catch (IOException e) {
                        ModConfigManager.this.plugin.getLogger().log(Level.SEVERE, "Failed to load config file for mod during hot-reload: " + modId, e);
                    }
                    catch (IllegalAccessException e) {
                        ModConfigManager.this.plugin.getLogger().log(Level.SEVERE, "Failed to access config fields for mod during hot-reload: " + modId, e);
                    }
                }
            }
        };
    }

    public void stopConfigWatcher() {
        if (this.configWatcherTask != null) {
            this.configWatcherTask.cancel();
            this.configWatcherTask = null;
            this.plugin.getLogger().info("Config watcher stopped.");
        }
    }

    public String getModConfigYamlContent(String modId) {
        File modConfigFile = this.modConfigFiles.get(modId);
        if (modConfigFile != null && modConfigFile.exists()) {
            try {
                return new String(Files.readAllBytes(modConfigFile.toPath()), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to read config.yml for mod: " + modId, e);
            }
        }
        return null;
    }

    public void setModConfigYamlContent(String modId, String yamlContent) {
        File modConfigFile = this.modConfigFiles.get(modId);
        if (modConfigFile != null) {
            try {
                Files.write(modConfigFile.toPath(), yamlContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                this.lastModifiedTimes.put(modId, modConfigFile.lastModified());
                this.plugin.getLogger().info("Updated config.yml for mod: " + modId + ". Reload will be triggered.");
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to write config.yml for mod: " + modId, e);
            }
        } else {
            this.plugin.getLogger().warning("Config file not found for mod: " + modId + ". Cannot set content.");
        }
    }
}

