/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.ModLoaderCommandExecutor;
import com.example.modloader.ModLoaderService;
import com.example.modloader.WebServer;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.java.JavaPlugin;

public final class ModLoader
extends JavaPlugin {
    private ModLoaderService modLoaderService;
    private WebServer webServer;

    public void onEnable() {
        File publishedModsFolder;
        this.getLogger().info("ModLoader plugin is enabling!");
        File modsFolder = new File(this.getDataFolder(), "Mods");
        if (!modsFolder.exists()) {
            if (modsFolder.mkdirs()) {
                this.getLogger().info("Created Mods folder at: " + modsFolder.getPath());
            } else {
                this.getLogger().severe("Failed to create Mods folder!");
                return;
            }
        }
        if (!(publishedModsFolder = new File(this.getDataFolder(), "published_mods")).exists()) {
            if (publishedModsFolder.mkdirs()) {
                this.getLogger().info("Created published_mods folder at: " + publishedModsFolder.getPath());
            } else {
                this.getLogger().severe("Failed to create published_mods folder!");
                return;
            }
        }
        this.saveResource("mod.policy", false);
        this.saveDefaultConfig();
        int webServerPort = this.getConfig().getInt("web-server-port", 25566);
        this.modLoaderService = new ModLoaderService(this);
        this.modLoaderService.loadModsAndGeneratePack();
        if (!this.modLoaderService.getResourcePackGenerator().generate()) {
            this.getLogger().severe("Could not generate resource pack. Aborting resource pack server startup.");
            return;
        }
        this.webServer = new WebServer(this, this.modLoaderService, this.modLoaderService.getResourcePackGenerator().getZipFile(), webServerPort, modsFolder);
        this.webServer.start();
        this.getCommand("modloader").setExecutor((CommandExecutor)new ModLoaderCommandExecutor(this, this.modLoaderService, this.webServer));
    }

    public void onDisable() {
        this.getLogger().info("ModLoader plugin is disabling!");
        if (this.webServer != null) {
            this.webServer.stop();
        }
        if (this.modLoaderService != null) {
            this.modLoaderService.disableMods();
        }
    }
}

