/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.AssetManager;
import com.example.modloader.CustomBlockRegistry;
import com.example.modloader.CustomCommandRegistry;
import com.example.modloader.CustomEventListenerRegistry;
import com.example.modloader.CustomItemRegistry;
import com.example.modloader.CustomMobRegistry;
import com.example.modloader.CustomRecipeRegistry;
import com.example.modloader.CustomWorldGeneratorRegistry;
import com.example.modloader.ModConfigManager;
import com.example.modloader.ModInfo;
import com.example.modloader.ModRepository;
import com.example.modloader.ModState;
import com.example.modloader.ResourcePackGenerator;
import com.example.modloader.api.CustomEnchantmentAPIImpl;
import com.example.modloader.api.CustomPotionEffectAPIImpl;
import com.example.modloader.api.CustomWorldGeneratorAPIImpl;
import com.example.modloader.api.ModAPIImpl;
import com.example.modloader.api.ModInitializer;
import com.example.modloader.api.ModMessageAPIImpl;
import com.example.modloader.api.dependencyinjection.API;
import com.example.modloader.api.dependencyinjection.Binder;
import com.example.modloader.api.dependencyinjection.ModAPIRegistry;
import com.example.modloader.api.dependencyinjection.ModInjector;
import com.example.modloader.api.event.EventBus;
import com.example.modloader.api.event.ModPostDisableEvent;
import com.example.modloader.api.event.ModPostEnableEvent;
import com.example.modloader.api.event.ModPostLoadEvent;
import com.example.modloader.api.event.ModPreDisableEvent;
import com.example.modloader.api.event.ModPreEnableEvent;
import com.example.modloader.api.event.ModPreLoadEvent;
import com.example.modloader.api.network.Networking;
import com.example.modloader.gui.ModManagementGUI;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.zafarkhaja.semver.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class ModLoaderService {
    private final JavaPlugin plugin;
    private final CustomItemRegistry itemRegistry;
    private final CustomMobRegistry mobRegistry;
    private final CustomBlockRegistry blockRegistry;
    private final CustomCommandRegistry commandRegistry;
    private final CustomEventListenerRegistry eventListenerRegistry;
    private final CustomRecipeRegistry recipeRegistry;
    private final CustomWorldGeneratorRegistry worldGeneratorRegistry;
    private final CustomEnchantmentAPIImpl customEnchantmentAPIImpl;
    private final CustomPotionEffectAPIImpl customPotionEffectAPIImpl;
    private final CustomWorldGeneratorAPIImpl customWorldGeneratorAPIImpl;
    private final ModMessageAPIImpl modMessageAPIImpl;
    private final File resourceStagingDir;
    private final ModConfigManager modConfigManager;
    private final AssetManager assetManager;
    private final ResourcePackGenerator resourcePackGenerator;
    private BukkitTask messageDispatchTask;
    private final EventBus eventBus;
    private final ModAPIRegistry modAPIRegistry;
    private final ModRepository modRepository;
    private final Map<String, ModInfo> availableMods = new HashMap<String, ModInfo>();
    private final List<ModInfo> loadOrder = new ArrayList<ModInfo>();
    private final Networking networking;

    public ModLoaderService(JavaPlugin plugin) {
        this.plugin = plugin;
        this.eventBus = new EventBus();
        this.itemRegistry = new CustomItemRegistry((Plugin)plugin, this.eventBus);
        this.mobRegistry = new CustomMobRegistry((Plugin)plugin, this.eventBus);
        this.blockRegistry = new CustomBlockRegistry((Plugin)plugin, this.eventBus);
        this.commandRegistry = new CustomCommandRegistry((Plugin)plugin);
        this.eventListenerRegistry = new CustomEventListenerRegistry((Plugin)plugin, this.eventBus);
        this.recipeRegistry = new CustomRecipeRegistry((Plugin)plugin);
        this.worldGeneratorRegistry = new CustomWorldGeneratorRegistry((Plugin)plugin);
        this.customEnchantmentAPIImpl = new CustomEnchantmentAPIImpl(plugin);
        this.customPotionEffectAPIImpl = new CustomPotionEffectAPIImpl(plugin);
        this.customWorldGeneratorAPIImpl = new CustomWorldGeneratorAPIImpl(plugin);
        this.networking = new Networking(plugin);
        this.networking.registerChannel("BungeeCord");
        this.modMessageAPIImpl = new ModMessageAPIImpl(plugin, "ModLoaderService", this.networking);
        this.modConfigManager = new ModConfigManager(plugin);
        this.assetManager = new AssetManager(plugin);
        this.resourceStagingDir = new File(plugin.getDataFolder(), "resource-pack-staging");
        int packFormat = plugin.getConfig().getInt("resource-pack.format", 34);
        String packDescription = plugin.getConfig().getString("resource-pack.description", "Dynamically generated server resources.");
        this.resourcePackGenerator = new ResourcePackGenerator(plugin, this.assetManager, packFormat, packDescription);
        this.modAPIRegistry = new ModAPIRegistry();
        this.modRepository = new ModRepository(plugin);
    }

    public void loadModsAndGeneratePack() {
        if (this.resourceStagingDir.exists()) {
            this.deleteDirectory(this.resourceStagingDir);
        }
        if (!this.resourceStagingDir.mkdirs()) {
            this.plugin.getLogger().severe("Failed to create resource pack staging directory.");
            return;
        }
        File modsFolder = new File(this.plugin.getDataFolder(), "Mods");
        if (!modsFolder.exists() || !modsFolder.isDirectory()) {
            this.plugin.getLogger().warning("Mods folder not found, skipping mod loading.");
            return;
        }
        File[] modFiles = modsFolder.listFiles((dir, name) -> name.endsWith(".modloader999"));
        if (modFiles == null || modFiles.length == 0) {
            this.plugin.getLogger().info("No .modloader999 mods found to load.");
            return;
        }
        for (File modFile : modFiles) {
            try {
                this.scanModloader999(modFile);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to scan mod: " + modFile.getName());
                e.printStackTrace();
            }
        }
        if (this.availableMods.isEmpty()) {
            this.plugin.getLogger().info("No valid .modloader999 mods found after scanning.");
            return;
        }
        try {
            this.resolveDependenciesAndLoad();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to resolve mod dependencies or load mods: " + e.getMessage());
            e.printStackTrace();
            this.disableMods();
            return;
        }
        this.plugin.getLogger().info("Finished processing mods. Resource pack assets staged.");
    }

    private void scanModloader999(File modFile) throws Exception {
        try (JarFile jarFile = new JarFile(modFile);){
            String mainClassName;
            String modDescription;
            String modAuthor;
            String modVersion;
            String modName;
            String modId;
            JarEntry modInfoEntry = jarFile.getJarEntry("modinfo.json");
            if (modInfoEntry == null) {
                this.plugin.getLogger().warning("Mod " + modFile.getName() + " is missing modinfo.json. Skipping.");
                return;
            }
            HashMap<String, String> dependencies = new HashMap();
            ArrayList<String> softDependencies = new ArrayList<String>();
            HashMap<String, String> customProperties = new HashMap();
            String apiVersion = "1.0.0";
            try (InputStream is = jarFile.getInputStream(modInfoEntry);
                 InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode modInfoJson = objectMapper.readTree(reader);
                modId = modInfoJson.get("id").asText();
                modName = modInfoJson.get("name").asText();
                modVersion = modInfoJson.get("version").asText();
                modAuthor = modInfoJson.get("author").asText();
                modDescription = modInfoJson.has("description") ? modInfoJson.get("description").asText() : "";
                mainClassName = modInfoJson.get("main").asText();
                if (modInfoJson.has("dependencies")) {
                    dependencies = objectMapper.convertValue((Object)modInfoJson.get("dependencies"), new TypeReference<Map<String, String>>(this){});
                }
                if (modInfoJson.has("softDependencies")) {
                    for (JsonNode softDepNode : modInfoJson.get("softDependencies")) {
                        softDependencies.add(softDepNode.asText());
                    }
                }
                if (modInfoJson.has("customProperties")) {
                    customProperties = objectMapper.convertValue((Object)modInfoJson.get("customProperties"), new TypeReference<Map<String, String>>(this){});
                }
            }
            ModInfo modInfo = new ModInfo(modId, modName, modVersion, modAuthor, modDescription, mainClassName, dependencies, softDependencies, customProperties, modFile, apiVersion);
            modInfo.setState(ModState.LOADED);
            this.availableMods.put(modName, modInfo);
            this.plugin.getLogger().info("Scanned mod: " + modName + " v" + modVersion + " by " + modAuthor);
            if (!this.modRepository.isModInRepository(modName)) {
                this.plugin.getLogger().info("Mod '" + modName + "' is not in the public repository. To publish it, use the command: /modloader publishmod " + modName);
            }
            jarFile.stream().forEach(entry -> {
                String entryName = entry.getName();
                if (!entry.isDirectory() && entryName.startsWith("assets/")) {
                    try (InputStream entryIs = jarFile.getInputStream((ZipEntry)entry);){
                        this.extractResource(entryName, entryIs);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().severe("Failed to extract resource " + entryName + " from " + modFile.getName());
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void resolveDependenciesAndLoad() throws Exception {
        void var4_11;
        HashMap graph = new HashMap();
        HashMap<String, Integer> inDegree = new HashMap<String, Integer>();
        for (ModInfo modInfo : this.availableMods.values()) {
            graph.put(modInfo.getName(), new HashSet());
            inDegree.put(modInfo.getName(), 0);
        }
        for (ModInfo modInfo : this.availableMods.values()) {
            URL[] urls = new URL[]{modInfo.getModFile().toURI().toURL()};
            URLClassLoader uRLClassLoader = new URLClassLoader(urls, this.plugin.getClass().getClass().getClassLoader());
            modInfo.setClassLoader(uRLClassLoader);
        }
        for (ModInfo modInfo : this.availableMods.values()) {
            if (modInfo.getState() == ModState.ERRORED) continue;
            for (Map.Entry entry : modInfo.getDependencies().entrySet()) {
                String dependencyName = (String)entry.getKey();
                String requiredVersionRange = (String)entry.getValue();
                if (!this.availableMods.containsKey(dependencyName)) {
                    this.plugin.getLogger().severe("Mod '" + modInfo.getName() + "' depends on unknown mod '" + dependencyName + "'. Marking as ERRORED.");
                    modInfo.setState(ModState.ERRORED);
                    break;
                }
                ModInfo dependencyMod = this.availableMods.get(dependencyName);
                Version dependencyVersion = Version.valueOf(dependencyMod.getVersion());
                if (!dependencyVersion.satisfies(requiredVersionRange)) {
                    this.plugin.getLogger().severe("Mod '" + modInfo.getName() + "' requires version " + requiredVersionRange + " of mod '" + dependencyName + "', but version " + dependencyMod.getVersion() + " is present. Marking as ERRORED.");
                    modInfo.setState(ModState.ERRORED);
                    break;
                }
                try {
                    Class<?> clazz = dependencyMod.getClassLoader().loadClass(dependencyMod.getMainClass());
                }
                catch (ClassNotFoundException e) {
                    this.plugin.getLogger().severe("Could not find main class for dependency '" + dependencyName + "'. Marking as ERRORED.");
                    modInfo.setState(ModState.ERRORED);
                    break;
                }
                if (modInfo.getState() == ModState.ERRORED) continue;
                ((Set)graph.get(dependencyName)).add(modInfo.getName());
                inDegree.put(modInfo.getName(), (Integer)inDegree.get(modInfo.getName()) + 1);
            }
            if (modInfo.getState() == ModState.ERRORED) continue;
            for (String string : modInfo.getSoftDependencies()) {
                if (this.availableMods.containsKey(string)) {
                    ((Set)graph.get(string)).add(modInfo.getName());
                    continue;
                }
                this.plugin.getLogger().info("Mod '" + modInfo.getName() + "' has a soft dependency on unknown mod '" + string + "'. Continuing without it.");
            }
        }
        LinkedList<ModInfo> queue = new LinkedList<ModInfo>();
        for (ModInfo mod : this.availableMods.values()) {
            if (mod.getState() != ModState.ERRORED && (Integer)inDegree.get(mod.getName()) == 0) {
                queue.add(mod);
                continue;
            }
            if (mod.getState() == ModState.ERRORED) continue;
            this.plugin.getLogger().info("Mod '" + mod.getName() + "' has in-degree " + String.valueOf(inDegree.get(mod.getName())) + ".");
        }
        boolean bl = false;
        while (!queue.isEmpty()) {
            ModInfo mod;
            mod = (ModInfo)queue.removeFirst();
            this.loadOrder.add(mod);
            ++var4_11;
            for (String dependentModName : (Set)graph.get(mod.getName())) {
                inDegree.put(dependentModName, (Integer)inDegree.get(dependentModName) - 1);
                if ((Integer)inDegree.get(dependentModName) != 0) continue;
                queue.add(this.availableMods.get(dependentModName));
            }
        }
        if (var4_11 != this.availableMods.size()) {
            HashSet<String> remainingMods = new HashSet<String>(this.availableMods.keySet());
            for (ModInfo loadedMod : this.loadOrder) {
                remainingMods.remove(loadedMod.getName());
            }
            throw new Exception("Circular dependency detected among mods: " + String.valueOf(remainingMods));
        }
        for (ModInfo modInfo : this.loadOrder) {
            if (modInfo.getState() == ModState.ERRORED) {
                this.plugin.getLogger().warning("Skipping errored mod: " + modInfo.getName());
                continue;
            }
            this.plugin.getLogger().info("Loading mod: " + modInfo.getName() + " v" + modInfo.getVersion());
            URL[] urls = new URL[]{modInfo.getModFile().toURI().toURL()};
            URLClassLoader classLoader = new URLClassLoader(urls, this.plugin.getClass().getClassLoader());
            modInfo.setClassLoader(classLoader);
            try (JarFile jarFile = new JarFile(modInfo.getModFile());){
                for (JarEntry entry : Collections.list(jarFile.entries())) {
                    String className;
                    Class<?> clazz;
                    if (!entry.getName().endsWith(".class") || !(clazz = classLoader.loadClass(className = entry.getName().replace('/', '.').substring(0, entry.getName().length() - 6))).isAnnotationPresent(API.class)) continue;
                    this.plugin.getLogger().info("Found API class: " + clazz.getName() + " in mod " + modInfo.getName());
                    this.modAPIRegistry.registerAPI(clazz, clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            Class<?> mainClass = classLoader.loadClass(modInfo.getMainClass());
            if (ModInitializer.class.isAssignableFrom(mainClass) && !mainClass.isInterface()) {
                this.plugin.getLogger().info("Found ModInitializer: " + mainClass.getName() + " for mod " + modInfo.getName());
                Binder binder = new Binder();
                ModInitializer modInitializer = (ModInitializer)mainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                modInitializer.configure(binder);
                binder.registerProviders(modInitializer);
                modInfo.setInitializer(modInitializer);
                modInfo.setState(ModState.LOADED);
                try {
                    this.eventBus.post(new ModPreLoadEvent(modInfo));
                    modInfo.setState(ModState.INITIALIZING);
                    this.modConfigManager.loadModConfig(modInfo);
                    ModAPIImpl modAPI = new ModAPIImpl(this.plugin, this.itemRegistry, this.mobRegistry, this.blockRegistry, this.commandRegistry, this.eventListenerRegistry, this.recipeRegistry, this.worldGeneratorRegistry, this.customEnchantmentAPIImpl, this.customPotionEffectAPIImpl, this.customWorldGeneratorAPIImpl, this.modConfigManager, this.modMessageAPIImpl, this.assetManager, modInfo.getName(), modInfo.getClassLoader(), this.eventBus);
                    modInfo.getInitializer().onPreLoad(modAPI);
                    modInfo.getInitializer().onLoad(modAPI);
                    modInfo.getInitializer().onPostLoad(modAPI);
                    this.plugin.getLogger().info("Mod " + modInfo.getName() + " initialized.");
                    this.eventBus.post(new ModPostLoadEvent(modInfo));
                    this.eventBus.post(new ModPreEnableEvent(modInfo));
                    modInfo.setState(ModState.ENABLED);
                    modInfo.getInitializer().onEnable();
                    this.plugin.getLogger().info("Mod " + modInfo.getName() + " enabled.");
                    this.eventBus.post(new ModPostEnableEvent(modInfo));
                    if (this.loadOrder.contains(modInfo)) continue;
                    this.loadOrder.add(modInfo);
                }
                catch (Throwable e) {
                    this.plugin.getLogger().severe("Failed to load or enable mod " + modInfo.getName() + ": " + e.getMessage());
                    e.printStackTrace();
                    modInfo.setState(ModState.ERRORED);
                }
                continue;
            }
            this.plugin.getLogger().warning("Main class " + modInfo.getMainClass() + " in mod " + modInfo.getName() + " does not implement ModInitializer. Marking as ERRORED.");
            modInfo.setState(ModState.ERRORED);
        }
    }

    private void extractResource(String resourcePath, InputStream inputStream) {
        File outputFile = new File(this.resourceStagingDir, resourcePath);
        outputFile.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytesRead);
            }
            this.plugin.getLogger().info("Extracted resource: " + resourcePath);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to extract resource: " + resourcePath);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableMods() {
        ArrayList<ModInfo> modsToDisable = new ArrayList<ModInfo>(this.loadOrder);
        Collections.reverse(modsToDisable);
        for (ModInfo modInfo : modsToDisable) {
            if (modInfo.getState() != ModState.ENABLED && modInfo.getState() != ModState.ERRORED) continue;
            this.plugin.getLogger().info("Disabling mod: " + modInfo.getName());
            this.eventBus.post(new ModPreDisableEvent(modInfo));
            modInfo.setState(ModState.DISABLING);
            try {
                if (modInfo.getInitializer() != null) {
                    modInfo.getInitializer().onPreDisable();
                    modInfo.getInitializer().onDisable();
                    modInfo.getInitializer().onPostDisable();
                }
                this.modConfigManager.unloadModConfig(modInfo.getName());
                this.commandRegistry.unregisterAll(modInfo.getName());
                this.eventListenerRegistry.unregisterAll(modInfo.getName());
                this.modMessageAPIImpl.unregisterAllHandlersForMod(modInfo.getName());
                this.assetManager.unregisterAllAssetsForMod(modInfo.getName());
                if (modInfo.getClassLoader() != null) {
                    modInfo.getClassLoader().close();
                }
                modInfo.setState(ModState.DISABLED);
                this.eventBus.post(new ModPostDisableEvent(modInfo));
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error disabling mod " + modInfo.getName() + ": " + e.getMessage());
                e.printStackTrace();
                modInfo.setState(ModState.ERRORED);
            }
        }
        this.loadOrder.clear();
        this.availableMods.clear();
        this.commandRegistry.unregisterAll();
        this.eventListenerRegistry.unregisterAll();
        this.recipeRegistry.unregisterAll();
        this.customEnchantmentAPIImpl.unregisterAll();
        this.customPotionEffectAPIImpl.unregisterAll();
        this.customWorldGeneratorAPIImpl.unregisterAll();
        if (this.messageDispatchTask != null) {
            this.messageDispatchTask.cancel();
            this.plugin.getLogger().info("Message dispatch task cancelled.");
        }
    }

    public List<ModInfo> getLoadedModsInfo() {
        return Collections.unmodifiableList(this.loadOrder);
    }

    public List<String> getAvailableModNames() {
        return new ArrayList<String>(this.availableMods.keySet());
    }

    public List<String> getEnabledModNames() {
        return this.loadOrder.stream().map(ModInfo::getName).collect(Collectors.toList());
    }

    public boolean isModEnabled(String modName) {
        return this.loadOrder.stream().anyMatch(mod -> mod.getName().equals(modName));
    }

    public ModInfo getModInfo(String modName) {
        return this.availableMods.get(modName);
    }

    public ResourcePackGenerator getResourcePackGenerator() {
        return this.resourcePackGenerator;
    }

    public ModConfigManager getModConfigManager() {
        return this.modConfigManager;
    }

    public ModRepository getModRepository() {
        return this.modRepository;
    }

    public ModManagementGUI createModManagementGUI() {
        return new ModManagementGUI(this.plugin, this);
    }

    public void unloadMod(String modName) throws Exception {
        ModInfo modToUnload = this.getModInfo(modName);
        if (modToUnload == null) {
            throw new IllegalArgumentException("Mod '" + modName + "' not found.");
        }
        if (modToUnload.getState() != ModState.ENABLED && modToUnload.getState() != ModState.ERRORED) {
            throw new IllegalStateException("Mod '" + modName + "' is not currently enabled or errored. Current state: " + String.valueOf((Object)modToUnload.getState()));
        }
        for (ModInfo mod : this.loadOrder) {
            if (mod.getState() != ModState.ENABLED || !mod.getDependencies().containsKey(modName)) continue;
            throw new IllegalStateException("Mod '" + mod.getName() + "' depends on '" + modName + "'. Cannot unload '" + modName + "' while '" + mod.getName() + "' is enabled.");
        }
        try {
            this.plugin.getLogger().info("Unloading mod: " + modToUnload.getName());
            modToUnload.setState(ModState.DISABLING);
            if (modToUnload.getInitializer() != null) {
                modToUnload.getInitializer().onDisable();
            }
            this.modConfigManager.unloadModConfig(modToUnload.getName());
            this.commandRegistry.unregisterAll(modToUnload.getName());
            this.eventListenerRegistry.unregisterAll(modToUnload.getName());
            this.modMessageAPIImpl.unregisterAllHandlersForMod(modToUnload.getName());
            this.assetManager.unregisterAllAssetsForMod(modToUnload.getName());
            if (modToUnload.getClassLoader() != null) {
                modToUnload.getClassLoader().close();
            }
            this.loadOrder.remove(modToUnload);
            this.availableMods.remove(modName);
            modToUnload.setState(ModState.UNLOADED);
            this.plugin.getLogger().info("Mod '" + modName + "' unloaded successfully!");
        }
        catch (Exception e) {
            modToUnload.setState(ModState.ERRORED);
            this.plugin.getLogger().severe("Error unloading mod " + modToUnload.getName() + ": " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMod(String modName) throws Exception {
        block19: {
            ModInfo modToLoad = this.availableMods.get(modName);
            if (modToLoad == null) {
                throw new IllegalArgumentException("Mod '" + modName + "' not found.");
            }
            if (modToLoad.getState() == ModState.LOADED || modToLoad.getState() == ModState.INITIALIZING || modToLoad.getState() == ModState.ENABLED) {
                throw new IllegalStateException("Mod '" + modName + "' is already loaded or enabled. Current state: " + String.valueOf((Object)modToLoad.getState()));
            }
            if (modToLoad.getState() == ModState.ERRORED) {
                throw new IllegalStateException("Mod '" + modName + "' is in an ERRORED state and cannot be loaded.");
            }
            if (modToLoad.getState() == ModState.DISABLED) {
                modToLoad.setState(ModState.LOADED);
                this.plugin.getLogger().info("Mod '" + modName + "' state changed from DISABLED to LOADED.");
                return;
            }
            try {
                URL[] urls = new URL[]{modToLoad.getModFile().toURI().toURL()};
                URLClassLoader classLoader = new URLClassLoader(urls, this.plugin.getClass().getClassLoader());
                modToLoad.setClassLoader(classLoader);
                try (JarFile jarFile = new JarFile(modToLoad.getModFile());){
                    for (JarEntry entry : Collections.list(jarFile.entries())) {
                        String className;
                        Class<?> clazz;
                        if (!entry.getName().endsWith(".class") || !(clazz = classLoader.loadClass(className = entry.getName().replace('/', '.').substring(0, entry.getName().length() - 6))).isAnnotationPresent(API.class)) continue;
                        this.plugin.getLogger().info("Found API class: " + clazz.getName() + " in mod " + modToLoad.getName());
                        this.modAPIRegistry.registerAPI(clazz, clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                }
                this.plugin.getLogger().info("Mod '" + modToLoad.getName() + "' classes loaded successfully!");
                Class<?> mainClass = classLoader.loadClass(modToLoad.getMainClass());
                if (ModInitializer.class.isAssignableFrom(mainClass) && !mainClass.isInterface()) {
                    this.plugin.getLogger().info("Found ModInitializer: " + mainClass.getName() + " for mod " + modToLoad.getName());
                    Binder binder = new Binder();
                    ModInjector injector = new ModInjector(binder, this.modAPIRegistry);
                    ModInitializer modInitializer = (ModInitializer)mainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    modInitializer.configure(binder);
                    binder.registerProviders(modInitializer);
                    modToLoad.setInitializer(modInitializer);
                    modToLoad.setState(ModState.LOADED);
                    try {
                        this.eventBus.post(new ModPreLoadEvent(modToLoad));
                        modToLoad.setState(ModState.INITIALIZING);
                        this.modConfigManager.loadModConfig(modToLoad);
                        ModAPIImpl modAPI = new ModAPIImpl(this.plugin, this.itemRegistry, this.mobRegistry, this.blockRegistry, this.commandRegistry, this.eventListenerRegistry, this.recipeRegistry, this.worldGeneratorRegistry, this.customEnchantmentAPIImpl, this.customPotionEffectAPIImpl, this.customWorldGeneratorAPIImpl, this.modConfigManager, this.modMessageAPIImpl, this.assetManager, modToLoad.getName(), modToLoad.getClassLoader(), this.eventBus);
                        modToLoad.getInitializer().onPreLoad(modAPI);
                        modToLoad.getInitializer().onLoad(modAPI);
                        modToLoad.getInitializer().onPostLoad(modAPI);
                        this.plugin.getLogger().info("Mod " + modToLoad.getName() + " initialized.");
                        this.eventBus.post(new ModPostLoadEvent(modToLoad));
                        this.eventBus.post(new ModPreEnableEvent(modToLoad));
                        modToLoad.setState(ModState.ENABLED);
                        modToLoad.getInitializer().onEnable();
                        this.plugin.getLogger().info("Mod " + modToLoad.getName() + " enabled.");
                        this.eventBus.post(new ModPostEnableEvent(modToLoad));
                        if (!this.loadOrder.contains(modToLoad)) {
                            this.loadOrder.add(modToLoad);
                        }
                        break block19;
                    }
                    catch (Throwable e) {
                        this.plugin.getLogger().severe("Failed to load or enable mod " + modToLoad.getName() + ": " + e.getMessage());
                        e.printStackTrace();
                        modToLoad.setState(ModState.ERRORED);
                    }
                    break block19;
                }
                this.plugin.getLogger().warning("Main class " + modToLoad.getMainClass() + " in mod " + modToLoad.getName() + " does not implement ModInitializer. Marking as ERRORED.");
                modToLoad.setState(ModState.ERRORED);
            }
            catch (Exception e) {
                modToLoad.setState(ModState.ERRORED);
                this.plugin.getLogger().severe("Error loading classes for mod " + modToLoad.getName() + ": " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
    }

    public void enableMod(String modName) throws Exception {
        ModInfo modToEnable = this.availableMods.get(modName);
        if (modToEnable == null) {
            throw new IllegalArgumentException("Mod '" + modName + "' not found.");
        }
        if (modToEnable.getState() == ModState.ENABLED) {
            throw new IllegalStateException("Mod '" + modName + "' is already enabled.");
        }
        if (modToEnable.getState() == ModState.ERRORED) {
            throw new IllegalStateException("Mod '" + modName + "' is in an ERRORED state and cannot be enabled.");
        }
        try {
            this.recursivelyEnableMod(modToEnable, new HashSet<String>());
            this.plugin.getLogger().info("Mod '" + modName + "' enabled successfully!");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error enabling mod " + modToEnable.getName() + ": " + e.getMessage());
            e.printStackTrace();
            modToEnable.setState(ModState.ERRORED);
            throw e;
        }
    }

    public void disableMod(String modName) throws Exception {
        ModInfo modToDisable = this.getModInfo(modName);
        if (modToDisable == null) {
            throw new IllegalArgumentException("Mod '" + modName + "' not found.");
        }
        if (modToDisable.getState() != ModState.ENABLED && modToDisable.getState() != ModState.ERRORED) {
            throw new IllegalStateException("Mod '" + modName + "' is not currently enabled or errored. Current state: " + String.valueOf((Object)modToDisable.getState()));
        }
        for (ModInfo mod : this.loadOrder) {
            if (mod.getState() != ModState.ENABLED || !mod.getDependencies().containsKey(modName)) continue;
            throw new IllegalStateException("Mod '" + mod.getName() + "' depends on '" + modName + "'. Cannot disable '" + modName + "' while '" + mod.getName() + "' is enabled.");
        }
        try {
            this.plugin.getLogger().info("Disabling mod: " + modToDisable.getName());
            modToDisable.setState(ModState.DISABLING);
            if (modToDisable.getInitializer() != null) {
                modToDisable.getInitializer().onPreDisable();
                modToDisable.getInitializer().onDisable();
                modToDisable.getInitializer().onPostDisable();
            }
            this.modConfigManager.unloadModConfig(modToDisable.getName());
            this.commandRegistry.unregisterAll(modToDisable.getName());
            this.eventListenerRegistry.unregisterAll(modToDisable.getName());
            this.modMessageAPIImpl.unregisterAllHandlersForMod(modToDisable.getName());
            this.assetManager.unregisterAllAssetsForMod(modToDisable.getName());
            if (modToDisable.getClassLoader() != null) {
                modToDisable.getClassLoader().close();
            }
            this.loadOrder.remove(modToDisable);
            this.availableMods.remove(modName);
            modToDisable.setState(ModState.UNLOADED);
            this.plugin.getLogger().info("Mod '" + modName + "' unloaded successfully!");
        }
        catch (Exception e) {
            modToDisable.setState(ModState.ERRORED);
            this.plugin.getLogger().severe("Error unloading mod " + modToDisable.getName() + ": " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    private void recursivelyEnableMod(ModInfo modInfo, Set<String> enablingStack) throws Exception {
        block26: {
            if (modInfo.getState() == ModState.ENABLED) {
                return;
            }
            if (modInfo.getState() == ModState.ERRORED) {
                throw new IllegalStateException("Cannot enable mod '" + modInfo.getName() + "' because it is in an ERRORED state.");
            }
            if (enablingStack.contains(modInfo.getName())) {
                throw new IllegalStateException("Circular dependency detected involving mod '" + modInfo.getName() + "'.");
            }
            enablingStack.add(modInfo.getName());
            for (Map.Entry<String, String> dependencyEntry : modInfo.getDependencies().entrySet()) {
                String dependencyName = dependencyEntry.getKey();
                ModInfo dependencyMod = this.availableMods.get(dependencyName);
                if (dependencyMod == null) {
                    throw new IllegalStateException("Mod '" + modInfo.getName() + "' depends on unknown mod '" + dependencyName + "'.");
                }
                if (dependencyMod.getState() == ModState.ENABLED) continue;
                this.recursivelyEnableMod(dependencyMod, enablingStack);
            }
            for (String softDependencyName : modInfo.getSoftDependencies()) {
                ModInfo softDependencyMod = this.availableMods.get(softDependencyName);
                if (softDependencyMod == null) {
                    this.plugin.getLogger().info("Mod '" + modInfo.getName() + "' has a soft dependency on unknown mod '" + softDependencyName + "'. Continuing without it.");
                    continue;
                }
                if (softDependencyMod.getState() == ModState.ENABLED) continue;
                try {
                    this.recursivelyEnableMod(softDependencyMod, enablingStack);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to enable soft dependency '" + softDependencyName + "' for mod '" + modInfo.getName() + "': " + e.getMessage());
                }
            }
            try {
                if (modInfo.getState() == ModState.UNLOADED || modInfo.getState() == ModState.DISABLED) {
                    URL[] urls = new URL[]{modInfo.getModFile().toURI().toURL()};
                    URLClassLoader classLoader = new URLClassLoader(urls, this.plugin.getClass().getClassLoader());
                    modInfo.setClassLoader(classLoader);
                    try (JarFile jarFile = new JarFile(modInfo.getModFile());){
                        for (JarEntry entry : Collections.list(jarFile.entries())) {
                            String className;
                            Class<?> clazz;
                            if (!entry.getName().endsWith(".class") || !(clazz = classLoader.loadClass(className = entry.getName().replace('/', '.').substring(0, entry.getName().length() - 6))).isAnnotationPresent(API.class)) continue;
                            this.plugin.getLogger().info("Found API class: " + clazz.getName() + " in mod " + modInfo.getName());
                            this.modAPIRegistry.registerAPI(clazz, clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                    }
                    Class<?> mainClass = classLoader.loadClass(modInfo.getMainClass());
                    if (ModInitializer.class.isAssignableFrom(mainClass) && !mainClass.isInterface()) {
                        this.plugin.getLogger().info("Found ModInitializer: " + mainClass.getName() + " for mod " + modInfo.getName());
                        Binder binder = new Binder();
                        ModInjector injector = new ModInjector(binder, this.modAPIRegistry);
                        ModInitializer modInitializer = (ModInitializer)mainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        modInitializer.configure(binder);
                        binder.registerProviders(modInitializer);
                        modInfo.setInitializer(modInitializer);
                        modInfo.setState(ModState.LOADED);
                    } else {
                        this.plugin.getLogger().warning("Main class " + modInfo.getMainClass() + " in mod " + modInfo.getName() + " does not implement ModInitializer. Marking as ERRORED.");
                        modInfo.setState(ModState.ERRORED);
                    }
                }
                if (modInfo.getState() == ModState.LOADED) {
                    modInfo.setState(ModState.INITIALIZING);
                    this.modConfigManager.loadModConfig(modInfo);
                    ModAPIImpl modAPI = new ModAPIImpl(this.plugin, this.itemRegistry, this.mobRegistry, this.blockRegistry, this.commandRegistry, this.eventListenerRegistry, this.recipeRegistry, this.worldGeneratorRegistry, this.customEnchantmentAPIImpl, this.customPotionEffectAPIImpl, this.customWorldGeneratorAPIImpl, this.modConfigManager, this.modMessageAPIImpl, this.assetManager, modInfo.getName(), modInfo.getClassLoader(), this.eventBus);
                    modInfo.getInitializer().onPreLoad(modAPI);
                    modInfo.getInitializer().onLoad(modAPI);
                    modInfo.getInitializer().onPostLoad(modAPI);
                    this.plugin.getLogger().info("Mod " + modInfo.getName() + " initialized.");
                    modInfo.setState(ModState.ENABLED);
                    modInfo.getInitializer().onEnable();
                    this.plugin.getLogger().info("Mod " + modInfo.getName() + " enabled.");
                    if (!this.loadOrder.contains(modInfo)) {
                        this.loadOrder.add(modInfo);
                    }
                    break block26;
                }
                throw new IllegalStateException("Unexpected state for mod '" + modInfo.getName() + "' during enabling: " + String.valueOf((Object)modInfo.getState()));
            }
            catch (Exception e) {
                modInfo.setState(ModState.ERRORED);
                this.plugin.getLogger().severe("Error enabling mod " + modInfo.getName() + ": " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
            finally {
                enablingStack.remove(modInfo.getName());
            }
        }
    }

    public void hotReloadMod(String modName) throws Exception {
        ModInfo modToReload = this.getModInfo(modName);
        if (modToReload == null) {
            throw new IllegalArgumentException("Mod '" + modName + "' not found.");
        }
        if (modToReload.getState() != ModState.ENABLED) {
            throw new IllegalStateException("Mod '" + modName + "' is not currently enabled. Current state: " + String.valueOf((Object)modToReload.getState()));
        }
        this.plugin.getLogger().info("Attempting to hot-reload mod: " + modName);
        this.disableMod(modName);
        this.loadMod(modName);
        this.enableMod(modName);
        this.plugin.getLogger().info("Mod '" + modName + "' hot-reloaded successfully!");
    }

    private boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                this.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }
}

