/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.FileAdapter;
import com.example.modloader.ModInfo;
import com.example.modloader.URLClassLoaderAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.plugin.java.JavaPlugin;

public class ModRepository {
    private final File repositoryFile;
    private final JavaPlugin plugin;
    private List<ModInfo> mods;

    public ModRepository(JavaPlugin plugin) {
        this.plugin = plugin;
        this.repositoryFile = new File(plugin.getDataFolder(), "repository.json");
        this.load();
    }

    private void load() {
        if (!this.repositoryFile.exists()) {
            this.mods = new ArrayList<ModInfo>();
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(this.repositoryFile);){
            Gson gson = new GsonBuilder().registerTypeAdapter(File.class, (Object)new FileAdapter()).registerTypeAdapter(URLClassLoader.class, (Object)new URLClassLoaderAdapter()).create();
            Type type = new TypeToken<List<ModInfo>>(this){}.getType();
            this.mods = (List)gson.fromJson((Reader)reader, type);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not load mod repository: " + e.getMessage());
            this.mods = new ArrayList<ModInfo>();
        }
    }

    private void save() {
        try (FileWriter writer = new FileWriter(this.repositoryFile);){
            Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(File.class, (Object)new FileAdapter()).registerTypeAdapter(URLClassLoader.class, (Object)new URLClassLoaderAdapter()).create();
            gson.toJson(this.mods, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save mod repository: " + e.getMessage());
        }
    }

    public boolean isModInRepository(String modName) {
        return this.mods.stream().anyMatch(mod -> mod.getName().equalsIgnoreCase(modName));
    }

    public void addMod(ModInfo modInfo) {
        if (!this.isModInRepository(modInfo.getName())) {
            this.mods.add(modInfo);
            this.save();
        }
    }

    public List<ModInfo> getAllMods() {
        return this.mods;
    }
}

