/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.Marketplace;
import com.example.modloader.ModInfo;
import com.example.modloader.ModLoaderService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public class WebServer {
    private final JavaPlugin plugin;
    private final ModLoaderService modLoaderService;
    private final File resourcePackFile;
    private final int port;
    private HttpServer server;
    private String resourcePackUrl;
    private String dashboardUrl;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Marketplace marketplace;

    public WebServer(JavaPlugin plugin, ModLoaderService modLoaderService, File resourcePackFile, int port, File modsDir) {
        this.plugin = plugin;
        this.modLoaderService = modLoaderService;
        this.resourcePackFile = resourcePackFile;
        this.port = port;
        this.marketplace = new Marketplace(modLoaderService.getModRepository(), modsDir);
    }

    public void start() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            this.server.setExecutor(Executors.newFixedThreadPool(4));
            this.server.createContext("/", this::handleStaticFileRequest);
            this.server.createContext("/api/mods", httpExchange -> {
                if ("GET".equals(httpExchange.getRequestMethod())) {
                    List<ModInfo> mods = this.modLoaderService.getLoadedModsInfo();
                    this.sendJsonResponse(httpExchange, 200, this.gson.toJson(mods));
                } else {
                    this.sendErrorResponse(httpExchange, 405, "Method Not Allowed");
                }
            });
            this.server.createContext("/api/mod/", httpExchange -> {
                String path = httpExchange.getRequestURI().getPath();
                String[] pathParts = path.split("/");
                if (pathParts.length >= 4 && "mod".equals(pathParts[2])) {
                    String modId = pathParts[3];
                    ModInfo modInfo = this.modLoaderService.getModInfo(modId);
                    if (modInfo != null) {
                        this.sendJsonResponse(httpExchange, 200, this.gson.toJson((Object)modInfo));
                    } else {
                        this.sendErrorResponse(httpExchange, 404, "Mod Not Found");
                    }
                } else {
                    this.sendErrorResponse(httpExchange, 400, "Bad Request");
                }
            });
            this.server.createContext("/api/mod/enable/", httpExchange -> {
                if ("POST".equals(httpExchange.getRequestMethod())) {
                    String path = httpExchange.getRequestURI().getPath();
                    String[] pathParts = path.split("/");
                    if (pathParts.length >= 5 && "enable".equals(pathParts[3])) {
                        String modId = pathParts[4];
                        try {
                            this.modLoaderService.enableMod(modId);
                            this.sendJsonResponse(httpExchange, 200, "{\"status\":\"success\", \"message\":\"Mod " + modId + " enabled.\"}");
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().log(Level.SEVERE, "Failed to enable mod " + modId, e);
                            this.sendErrorResponse(httpExchange, 500, "Failed to enable mod: " + e.getMessage());
                        }
                    } else {
                        this.sendErrorResponse(httpExchange, 400, "Bad Request");
                    }
                } else {
                    this.sendErrorResponse(httpExchange, 405, "Method Not Allowed");
                }
            });
            this.server.createContext("/api/mod/disable/", httpExchange -> {
                if ("POST".equals(httpExchange.getRequestMethod())) {
                    String path = httpExchange.getRequestURI().getPath();
                    String[] pathParts = path.split("/");
                    if (pathParts.length >= 5 && "disable".equals(pathParts[3])) {
                        String modId = pathParts[4];
                        try {
                            this.modLoaderService.disableMod(modId);
                            this.sendJsonResponse(httpExchange, 200, "{\"status\":\"success\", \"message\":\"Mod " + modId + " disabled.\"}");
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().log(Level.SEVERE, "Failed to disable mod " + modId, e);
                            this.sendErrorResponse(httpExchange, 500, "Failed to disable mod: " + e.getMessage());
                        }
                    } else {
                        this.sendErrorResponse(httpExchange, 400, "Bad Request");
                    }
                } else {
                    this.sendErrorResponse(httpExchange, 405, "Method Not Allowed");
                }
            });
            this.server.createContext("/api/mod/hotreload/", httpExchange -> {
                if ("POST".equals(httpExchange.getRequestMethod())) {
                    String path = httpExchange.getRequestURI().getPath();
                    String[] pathParts = path.split("/");
                    if (pathParts.length >= 5 && "hotreload".equals(pathParts[3])) {
                        String modId = pathParts[4];
                        try {
                            this.modLoaderService.hotReloadMod(modId);
                            this.sendJsonResponse(httpExchange, 200, "{\"status\":\"success\", \"message\":\"Mod " + modId + " hot-reloaded.\"}");
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().log(Level.SEVERE, "Failed to hot-reload mod " + modId, e);
                            this.sendErrorResponse(httpExchange, 500, "Failed to hot-reload mod: " + e.getMessage());
                        }
                    } else {
                        this.sendErrorResponse(httpExchange, 400, "Bad Request");
                    }
                } else {
                    this.sendErrorResponse(httpExchange, 405, "Method Not Allowed");
                }
            });
            this.server.createContext("/api/mod/config/", httpExchange -> {
                String path = httpExchange.getRequestURI().getPath();
                String[] pathParts = path.split("/");
                if (pathParts.length >= 5 && "config".equals(pathParts[3])) {
                    String modId = pathParts[4];
                    ModInfo modInfo = this.modLoaderService.getModInfo(modId);
                    if (modInfo == null) {
                        this.sendErrorResponse(httpExchange, 404, "Mod Not Found");
                        return;
                    }
                    if ("GET".equals(httpExchange.getRequestMethod())) {
                        String configContent = this.modLoaderService.getModConfigManager().getModConfigYamlContent(modId);
                        if (configContent != null) {
                            httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
                            this.sendResponse(httpExchange, 200, configContent);
                        } else {
                            this.sendErrorResponse(httpExchange, 404, "Config Not Found");
                        }
                    } else if ("POST".equals(httpExchange.getRequestMethod())) {
                        try (InputStream is = httpExchange.getRequestBody();){
                            String requestBody = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                            this.modLoaderService.getModConfigManager().setModConfigYamlContent(modId, requestBody);
                            this.sendJsonResponse(httpExchange, 200, "{\"status\":\"success\", \"message\":\"Mod " + modId + " config updated.\"}");
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().log(Level.SEVERE, "Failed to update config for mod " + modId, e);
                            this.sendErrorResponse(httpExchange, 500, "Failed to update config: " + e.getMessage());
                        }
                    } else {
                        this.sendErrorResponse(httpExchange, 405, "Method Not Allowed");
                    }
                } else {
                    this.sendErrorResponse(httpExchange, 400, "Bad Request");
                }
            });
            this.server.createContext("/pack.zip", httpExchange -> {
                if (!this.resourcePackFile.exists()) {
                    this.sendErrorResponse(httpExchange, 404, "Resource Pack Not Found");
                    return;
                }
                httpExchange.sendResponseHeaders(200, this.resourcePackFile.length());
                try (OutputStream os = httpExchange.getResponseBody();){
                    Files.copy(this.resourcePackFile.toPath(), os);
                }
            });
            this.server.start();
            String address = "modloadermarketplace.com";
            this.resourcePackUrl = "http://" + address + ":" + this.port + "/pack.zip";
            this.dashboardUrl = "http://" + address + ":" + this.port + "/";
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to start web server on port " + this.port);
            e.printStackTrace();
        }
    }

    private void handleStaticFileRequest(HttpExchange httpExchange) throws IOException {
        String path = httpExchange.getRequestURI().getPath();
        if (path.equals("/")) {
            path = "/index.html";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String resourcePath = "dashboard/" + path;
        try (InputStream in = this.plugin.getResource(resourcePath);){
            if (in == null) {
                this.sendErrorResponse(httpExchange, 404, "Not Found");
                return;
            }
            String contentType = Files.probeContentType(Paths.get(path, new String[0]));
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            httpExchange.getResponseHeaders().set("Content-Type", contentType);
            httpExchange.sendResponseHeaders(200, in.available());
            try (OutputStream os = httpExchange.getResponseBody();){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = in.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
            }
        }
    }

    private void sendResponse(HttpExchange httpExchange, int statusCode, String response) throws IOException {
        httpExchange.sendResponseHeaders(statusCode, response.length());
        try (OutputStream os = httpExchange.getResponseBody();){
            os.write(response.getBytes(StandardCharsets.UTF_8));
        }
    }

    public String getResourcePackUrl() {
        return this.resourcePackUrl;
    }

    public String getDashboardUrl() {
        if (this.dashboardUrl == null || this.dashboardUrl.contains("127.0.0.1")) {
            String address = "modloadermarketplace.com";
            return "http://" + address + ":" + this.port + "/";
        }
        return this.dashboardUrl;
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
            this.plugin.getLogger().info("Web server stopped.");
        }
    }

    private void sendJsonResponse(HttpExchange httpExchange, int statusCode, String jsonResponse) throws IOException {
        httpExchange.getResponseHeaders().set("Content-Type", "application/json");
        this.sendResponse(httpExchange, statusCode, jsonResponse);
    }

    private void sendErrorResponse(HttpExchange httpExchange, int statusCode, String message) throws IOException {
        JsonObject errorResponse = new JsonObject();
        errorResponse.addProperty("status", "error");
        errorResponse.addProperty("message", message);
        this.sendJsonResponse(httpExchange, statusCode, this.gson.toJson((JsonElement)errorResponse));
    }
}

