/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api;

import com.example.modloader.AssetManager;
import com.example.modloader.api.AssetBundle;
import com.example.modloader.api.AssetBundleImpl;
import com.example.modloader.api.CustomAssetAPI;
import java.io.File;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomAssetAPIImpl
implements CustomAssetAPI {
    private final JavaPlugin plugin;
    private final String modId;
    private final URLClassLoader modClassLoader;
    private final AssetManager assetManager;
    private final Map<String, AssetBundle> registeredBundles = new HashMap<String, AssetBundle>();

    public CustomAssetAPIImpl(JavaPlugin plugin, String modId, URLClassLoader modClassLoader, AssetManager assetManager) {
        this.plugin = plugin;
        this.modId = modId;
        this.modClassLoader = modClassLoader;
        this.assetManager = assetManager;
    }

    @Override
    public void registerSound(String assetId, String soundFilePath) {
        this.registerSound(assetId, soundFilePath, 0);
    }

    @Override
    public void registerSound(String assetId, String soundFilePath, int priority) {
        this.assetManager.registerAsset(this.modId, assetId, soundFilePath, this.modClassLoader, priority);
    }

    @Override
    public void registerModel(String assetId, String modelFilePath) {
        this.registerModel(assetId, modelFilePath, 0);
    }

    @Override
    public void registerModel(String assetId, String modelFilePath, int priority) {
        this.assetManager.registerAsset(this.modId, assetId, modelFilePath, this.modClassLoader, priority);
    }

    @Override
    public void registerTexture(String assetId, String textureFilePath) {
        this.registerTexture(assetId, textureFilePath, 0);
    }

    @Override
    public void registerTexture(String assetId, String textureFilePath, int priority) {
        this.assetManager.registerAsset(this.modId, assetId, textureFilePath, this.modClassLoader, priority);
    }

    @Override
    public File getAssetFile(String assetId) {
        return this.assetManager.getAllStagedAssets().get(assetId);
    }

    @Override
    public String getAssetUrl(String assetId) {
        String stagingDirPath;
        String absolutePath;
        File assetFile = this.getAssetFile(assetId);
        if (assetFile != null && (absolutePath = assetFile.getAbsolutePath()).startsWith(stagingDirPath = this.assetManager.getResourcePackStagingDir().getAbsolutePath())) {
            String relativePath = absolutePath.substring(stagingDirPath.length());
            if (relativePath.startsWith(File.separator)) {
                relativePath = relativePath.substring(File.separator.length());
            }
            return relativePath.replace(File.separator, "/");
        }
        return null;
    }

    @Override
    public AssetBundle createAssetBundle(String bundleId) {
        return new AssetBundleImpl(bundleId);
    }

    @Override
    public boolean registerAssetBundle(AssetBundle bundle) {
        if (this.registeredBundles.containsKey(bundle.getId())) {
            this.plugin.getLogger().warning("Asset bundle with ID '" + bundle.getId() + "' already registered. Skipping.");
            return false;
        }
        this.registeredBundles.put(bundle.getId(), bundle);
        this.plugin.getLogger().info("Registered asset bundle: " + bundle.getId());
        return true;
    }

    @Override
    public AssetBundle getAssetBundle(String bundleId) {
        return this.registeredBundles.get(bundleId);
    }
}

