/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api;

import com.example.modloader.CustomPotionEffectType;
import com.example.modloader.api.CustomPotionEffectAPI;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CustomPotionEffectAPIImpl
implements CustomPotionEffectAPI {
    private final JavaPlugin plugin;
    private final Map<String, CustomPotionEffectType> registeredPotionEffectTypes = new HashMap<String, CustomPotionEffectType>();

    public CustomPotionEffectAPIImpl(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean registerPotionEffectType(CustomPotionEffectType effectType) {
        if (this.registeredPotionEffectTypes.containsKey(effectType.getKey().getKey())) {
            this.plugin.getLogger().warning("Attempted to register potion effect type with duplicate key: " + effectType.getKey().getKey());
            return false;
        }
        if (PotionEffectType.getByKey((NamespacedKey)effectType.getKey()) != null) {
            this.plugin.getLogger().warning("Attempted to register potion effect type with key that conflicts with a vanilla effect: " + effectType.getKey().getKey());
            return false;
        }
        try {
            Field keyField = PotionEffectType.class.getDeclaredField("byKey");
            keyField.setAccessible(true);
            Map byKey = (Map)keyField.get(null);
            byKey.put(effectType.getKey(), effectType);
            Field nameField = PotionEffectType.class.getDeclaredField("byName");
            nameField.setAccessible(true);
            Map byName = (Map)nameField.get(null);
            byName.put(effectType.getName(), effectType);
            this.registeredPotionEffectTypes.put(effectType.getKey().getKey(), effectType);
            this.plugin.getLogger().info("Registered custom potion effect type: " + effectType.getName() + " (" + effectType.getKey().getKey() + ")");
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to register custom potion effect type: " + effectType.getName(), e);
            return false;
        }
    }

    @Override
    public CustomPotionEffectType getPotionEffectType(String namespace) {
        return this.registeredPotionEffectTypes.get(namespace);
    }

    @Override
    public boolean applyPotionEffect(LivingEntity entity, CustomPotionEffectType effectType, int duration, int amplifier, boolean ambient, boolean particles, boolean icon) {
        if (effectType == null) {
            this.plugin.getLogger().warning("Attempted to apply a null custom potion effect type.");
            return false;
        }
        PotionEffect potionEffect = new PotionEffect((PotionEffectType)effectType, duration, amplifier, ambient, particles, icon);
        return entity.addPotionEffect(potionEffect);
    }

    @Override
    public boolean applyPotionEffect(LivingEntity entity, PotionEffect effect) {
        if (effect == null) {
            this.plugin.getLogger().warning("Attempted to apply a null potion effect.");
            return false;
        }
        return entity.addPotionEffect(effect);
    }

    public void unregisterAll() {
        try {
            Field byKeyField = PotionEffectType.class.getDeclaredField("byKey");
            byKeyField.setAccessible(true);
            Map byKey = (Map)byKeyField.get(null);
            Field byNameField = PotionEffectType.class.getDeclaredField("byName");
            byNameField.setAccessible(true);
            Map byName = (Map)byNameField.get(null);
            for (CustomPotionEffectType effectType : this.registeredPotionEffectTypes.values()) {
                byKey.remove(effectType.getKey());
                byName.remove(effectType.getName());
                this.plugin.getLogger().info("Unregistered custom potion effect type: " + effectType.getName());
            }
            this.registeredPotionEffectTypes.clear();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to unregister custom potion effect types.", e);
        }
    }
}

