/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api;

import com.example.modloader.CustomStructureManager;
import com.example.modloader.api.CustomStructureAPI;
import java.io.File;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomStructureAPIImpl
implements CustomStructureAPI {
    private final CustomStructureManager structureManager;
    private final JavaPlugin plugin;

    public CustomStructureAPIImpl(JavaPlugin plugin) {
        this.plugin = plugin;
        this.structureManager = new CustomStructureManager(plugin);
    }

    @Override
    public boolean loadStructure(String structureId, File structureFile) {
        return this.structureManager.loadStructure(structureId, structureFile);
    }

    @Override
    public boolean spawnStructure(String structureId, Location location, Random random, int rotation, boolean mirror, float integrity) {
        return this.structureManager.spawnStructure(structureId, location, random, rotation, mirror, integrity);
    }

    @Override
    public CompletableFuture<Boolean> spawnStructureAsync(String structureId, Location location, Random random, int rotation, boolean mirror, float integrity) {
        return CompletableFuture.supplyAsync(() -> this.structureManager.spawnStructure(structureId, location, random, rotation, mirror, integrity), runnable -> this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, runnable));
    }
}

