/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api;

import com.example.modloader.api.CustomWorldGeneratorAPI;
import com.example.modloader.api.world.CustomBiome;
import com.example.modloader.api.world.CustomChunkGenerator;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomWorldGeneratorAPIImpl
implements CustomWorldGeneratorAPI {
    private final JavaPlugin plugin;
    private final Map<String, CustomChunkGenerator> registeredGenerators = new HashMap<String, CustomChunkGenerator>();
    private final Map<String, CustomBiome> registeredBiomes = new HashMap<String, CustomBiome>();

    public CustomWorldGeneratorAPIImpl(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean registerCustomChunkGenerator(String worldName, CustomChunkGenerator generator) {
        if (this.registeredGenerators.containsKey(worldName.toLowerCase())) {
            this.plugin.getLogger().warning("Attempted to register a custom chunk generator for an already registered world: " + worldName);
            return false;
        }
        this.registeredGenerators.put(worldName.toLowerCase(), generator);
        this.plugin.getLogger().info("Registered custom chunk generator for world: " + worldName);
        return true;
    }

    @Override
    public CustomChunkGenerator getCustomChunkGenerator(String worldName) {
        return this.registeredGenerators.get(worldName.toLowerCase());
    }

    @Override
    public boolean registerCustomBiome(String biomeId, CustomBiome biome) {
        if (this.registeredBiomes.containsKey(biomeId.toLowerCase())) {
            this.plugin.getLogger().warning("Attempted to register a custom biome for an already registered ID: " + biomeId);
            return false;
        }
        this.registeredBiomes.put(biomeId.toLowerCase(), biome);
        this.plugin.getLogger().info("Registered custom biome: " + biomeId);
        return true;
    }

    @Override
    public CustomBiome getCustomBiome(String biomeId) {
        return this.registeredBiomes.get(biomeId.toLowerCase());
    }

    public void unregisterAll() {
        this.registeredGenerators.clear();
        this.registeredBiomes.clear();
        this.plugin.getLogger().info("Unregistered all custom chunk generators and biomes.");
    }
}

