/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api;

import com.example.modloader.api.DimensionAPI;
import com.example.modloader.api.world.CustomChunkGenerator;
import com.example.modloader.api.world.CustomDimension;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.java.JavaPlugin;

public class DimensionAPIImpl
implements DimensionAPI {
    private final JavaPlugin plugin;
    private final Map<String, CustomDimension> registeredDimensions = new HashMap<String, CustomDimension>();

    public DimensionAPIImpl(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public World createWorld(String worldName, World.Environment environment) {
        return this.createWorld(worldName, environment, null);
    }

    @Override
    public World createWorld(String worldName, World.Environment environment, CustomChunkGenerator generator) {
        World world;
        WorldCreator creator = new WorldCreator(worldName);
        creator.environment(environment);
        if (generator != null) {
            creator.generator((ChunkGenerator)generator);
        }
        if ((world = creator.createWorld()) != null) {
            this.plugin.getLogger().info("Created world: " + worldName + " with environment: " + environment.name());
        } else {
            this.plugin.getLogger().warning("Failed to create world: " + worldName);
        }
        return world;
    }

    @Override
    public World createWorld(CustomDimension customDimension) {
        World world;
        WorldCreator creator = new WorldCreator(customDimension.getName());
        creator.environment(customDimension.getEnvironment());
        creator.seed(customDimension.getSeed());
        creator.hardcore(customDimension.isHardcore());
        if (customDimension.getChunkGenerator() != null) {
            creator.generator(customDimension.getChunkGenerator());
        }
        if ((world = creator.createWorld()) != null) {
            this.plugin.getLogger().info("Created custom world: " + customDimension.getName() + " with environment: " + customDimension.getEnvironment().name());
        } else {
            this.plugin.getLogger().warning("Failed to create custom world: " + customDimension.getName());
        }
        return world;
    }

    @Override
    public World loadWorld(String worldName) {
        World world = Bukkit.getWorld((String)worldName);
        if (world != null) {
            this.plugin.getLogger().info("World '" + worldName + "' is already loaded.");
            return world;
        }
        WorldCreator creator = new WorldCreator(worldName);
        world = creator.createWorld();
        if (world != null) {
            this.plugin.getLogger().info("Loaded world: " + worldName);
        } else {
            this.plugin.getLogger().warning("Failed to load world: " + worldName);
        }
        return world;
    }

    @Override
    public boolean unloadWorld(String worldName, boolean save) {
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            this.plugin.getLogger().warning("Attempted to unload world '" + worldName + "', but it is not loaded.");
            return false;
        }
        boolean success = Bukkit.unloadWorld((World)world, (boolean)save);
        if (success) {
            this.plugin.getLogger().info("Unloaded world: " + worldName + " (saved: " + save + ")");
        } else {
            this.plugin.getLogger().warning("Failed to unload world: " + worldName);
        }
        return success;
    }

    @Override
    public World getWorld(String worldName) {
        return Bukkit.getWorld((String)worldName);
    }

    @Override
    public boolean registerCustomDimension(String dimensionId, CustomDimension customDimension) {
        if (this.registeredDimensions.containsKey(dimensionId.toLowerCase())) {
            this.plugin.getLogger().warning("Attempted to register a custom dimension for an already registered ID: " + dimensionId);
            return false;
        }
        this.registeredDimensions.put(dimensionId.toLowerCase(), customDimension);
        this.plugin.getLogger().info("Registered custom dimension: " + dimensionId);
        return true;
    }

    @Override
    public CustomDimension getCustomDimension(String dimensionId) {
        return this.registeredDimensions.get(dimensionId.toLowerCase());
    }
}

