/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api;

import com.example.modloader.AssetManager;
import com.example.modloader.CustomBlock;
import com.example.modloader.CustomBlockRegistry;
import com.example.modloader.CustomCommandRegistry;
import com.example.modloader.CustomEventListenerRegistry;
import com.example.modloader.CustomItemRegistry;
import com.example.modloader.CustomMob;
import com.example.modloader.CustomMobRegistry;
import com.example.modloader.CustomRecipeRegistry;
import com.example.modloader.CustomWorldGeneratorRegistry;
import com.example.modloader.ModConfigManager;
import com.example.modloader.api.CustomAssetAPI;
import com.example.modloader.api.CustomAssetAPIImpl;
import com.example.modloader.api.CustomEnchantmentAPI;
import com.example.modloader.api.CustomInventoryAPI;
import com.example.modloader.api.CustomInventoryAPIImpl;
import com.example.modloader.api.CustomParticleAPI;
import com.example.modloader.api.CustomParticleAPIImpl;
import com.example.modloader.api.CustomPotionEffectAPI;
import com.example.modloader.api.CustomSoundAPI;
import com.example.modloader.api.CustomSoundAPIImpl;
import com.example.modloader.api.CustomStructureAPI;
import com.example.modloader.api.CustomStructureAPIImpl;
import com.example.modloader.api.CustomWorldGeneratorAPI;
import com.example.modloader.api.CustomWorldPopulator;
import com.example.modloader.api.DimensionAPI;
import com.example.modloader.api.DimensionAPIImpl;
import com.example.modloader.api.ModAPI;
import com.example.modloader.api.ModCommandExecutor;
import com.example.modloader.api.ModMessageAPI;
import com.example.modloader.api.config.ModConfig;
import com.example.modloader.api.event.EventBus;
import com.example.modloader.api.event.PreRegisterBlockEvent;
import com.example.modloader.api.event.PreRegisterItemEvent;
import com.example.modloader.api.event.PreRegisterMobEvent;
import com.example.modloader.api.gui.GUIAPI;
import com.example.modloader.api.gui.GUIAPIImpl;
import com.example.modloader.api.mob.CustomMobSpawner;
import com.example.modloader.api.network.Networking;
import com.example.modloader.api.permissions.Permissions;
import com.example.modloader.api.world.CustomOreGenerator;
import com.example.modloader.api.world.CustomStructureGenerator;
import com.example.modloader.api.world.CustomTreeGenerator;
import com.example.modloader.api.world.ProceduralGenerationAPI;
import com.example.modloader.api.world.ProceduralGenerationAPIImpl;
import java.net.URLClassLoader;
import org.bukkit.block.Biome;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.java.JavaPlugin;

public class ModAPIImpl
implements ModAPI {
    private final JavaPlugin plugin;
    private final CustomItemRegistry itemRegistry;
    private final CustomMobRegistry mobRegistry;
    private final CustomBlockRegistry blockRegistry;
    private final CustomCommandRegistry commandRegistry;
    private final CustomEventListenerRegistry eventListenerRegistry;
    private final CustomRecipeRegistry recipeRegistry;
    private final CustomWorldGeneratorRegistry worldGeneratorRegistry;
    private final CustomInventoryAPI customInventoryAPI;
    private final CustomParticleAPI customParticleAPI;
    private final CustomSoundAPI customSoundAPI;
    private final CustomEnchantmentAPI customEnchantmentAPI;
    private final CustomPotionEffectAPI customPotionEffectAPI;
    private final CustomWorldGeneratorAPI customWorldGeneratorAPI;
    private final DimensionAPI dimensionAPI;
    private final CustomStructureAPI customStructureAPI;
    private final CustomAssetAPI customAssetAPI;
    private final ModConfigManager modConfigManager;
    private final ModMessageAPI modMessageAPI;
    private final String modId;
    private final EventBus eventBus;
    private final Permissions permissions;
    private final Networking networking;
    private final GUIAPI guiAPI;
    private final ProceduralGenerationAPI proceduralGenerationAPI;

    public ModAPIImpl(JavaPlugin plugin, CustomItemRegistry itemRegistry, CustomMobRegistry mobRegistry, CustomBlockRegistry blockRegistry, CustomCommandRegistry commandRegistry, CustomEventListenerRegistry eventListenerRegistry, CustomRecipeRegistry recipeRegistry, CustomWorldGeneratorRegistry worldGeneratorRegistry, CustomEnchantmentAPI customEnchantmentAPI, CustomPotionEffectAPI customPotionEffectAPI, CustomWorldGeneratorAPI customWorldGeneratorAPI, ModConfigManager modConfigManager, ModMessageAPI modMessageAPI, AssetManager assetManager, String modId, URLClassLoader modClassLoader, EventBus eventBus) {
        this.plugin = plugin;
        this.itemRegistry = itemRegistry;
        this.mobRegistry = mobRegistry;
        this.blockRegistry = blockRegistry;
        this.commandRegistry = commandRegistry;
        this.eventListenerRegistry = eventListenerRegistry;
        this.recipeRegistry = recipeRegistry;
        this.worldGeneratorRegistry = worldGeneratorRegistry;
        this.customInventoryAPI = new CustomInventoryAPIImpl(plugin);
        this.customParticleAPI = new CustomParticleAPIImpl();
        this.customSoundAPI = new CustomSoundAPIImpl();
        this.customEnchantmentAPI = customEnchantmentAPI;
        this.customPotionEffectAPI = customPotionEffectAPI;
        this.customWorldGeneratorAPI = customWorldGeneratorAPI;
        this.dimensionAPI = new DimensionAPIImpl(plugin);
        this.customStructureAPI = new CustomStructureAPIImpl(plugin);
        this.modConfigManager = modConfigManager;
        this.modMessageAPI = modMessageAPI;
        this.customAssetAPI = new CustomAssetAPIImpl(plugin, modId, modClassLoader, assetManager);
        this.modId = modId;
        this.eventBus = eventBus;
        this.permissions = new Permissions();
        this.networking = new Networking(plugin);
        this.guiAPI = new GUIAPIImpl(plugin);
        this.proceduralGenerationAPI = new ProceduralGenerationAPIImpl(plugin);
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void registerItem(String itemId, ItemStack item) {
        PreRegisterItemEvent event = new PreRegisterItemEvent(itemId, item);
        this.eventBus.post(event);
        if (!event.isCancelled()) {
            this.itemRegistry.register(itemId, item);
        }
    }

    @Override
    public void registerMob(CustomMob customMob) {
        PreRegisterMobEvent event = new PreRegisterMobEvent(customMob);
        this.eventBus.post(event);
        if (!event.isCancelled()) {
            this.mobRegistry.register(customMob);
        }
    }

    @Override
    public void registerBlock(CustomBlock customBlock) {
        PreRegisterBlockEvent event = new PreRegisterBlockEvent(customBlock);
        this.eventBus.post(event);
        if (!event.isCancelled()) {
            this.blockRegistry.register(customBlock);
        }
    }

    @Override
    public void registerCommand(String commandName, ModCommandExecutor executor) {
        this.commandRegistry.register(commandName, executor, this.modId);
    }

    @Override
    public void registerListener(Listener listener) {
        this.eventListenerRegistry.register(listener, this.modId);
    }

    @Override
    public void registerEventListener(Object listenerObject) {
        this.eventListenerRegistry.register(listenerObject, this.modId);
    }

    @Override
    public void registerRecipe(Recipe recipe) {
        this.recipeRegistry.register(recipe);
    }

    @Override
    public void registerWorldPopulator(CustomWorldPopulator populator, String[] worldNames, Biome ... biomes) {
        this.worldGeneratorRegistry.registerPopulator(populator, worldNames, biomes);
    }

    @Override
    public void registerOreGenerator(CustomOreGenerator generator, String[] worldNames, Biome ... biomes) {
        this.worldGeneratorRegistry.registerOreGenerator(generator, worldNames, biomes);
    }

    @Override
    public void registerTreeGenerator(CustomTreeGenerator generator, String[] worldNames, Biome ... biomes) {
        this.worldGeneratorRegistry.registerTreeGenerator(generator, worldNames, biomes);
    }

    @Override
    public void registerStructureGenerator(CustomStructureGenerator generator, String[] worldNames, Biome ... biomes) {
        this.worldGeneratorRegistry.registerStructureGenerator(generator, worldNames, biomes);
    }

    @Override
    public void registerMobSpawner(CustomMobSpawner spawner) {
        this.mobRegistry.registerSpawner(spawner);
    }

    @Override
    public CustomMobRegistry getCustomMobRegistry() {
        return this.mobRegistry;
    }

    @Override
    public CustomCommandRegistry getCustomCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public CustomInventoryAPI getCustomInventoryAPI() {
        return this.customInventoryAPI;
    }

    @Override
    public CustomParticleAPI getCustomParticleAPI() {
        return this.customParticleAPI;
    }

    @Override
    public CustomSoundAPI getCustomSoundAPI() {
        return this.customSoundAPI;
    }

    @Override
    public CustomEnchantmentAPI getCustomEnchantmentAPI() {
        return this.customEnchantmentAPI;
    }

    @Override
    public CustomPotionEffectAPI getCustomPotionEffectAPI() {
        return this.customPotionEffectAPI;
    }

    @Override
    public CustomWorldGeneratorAPI getCustomWorldGeneratorAPI() {
        return this.customWorldGeneratorAPI;
    }

    @Override
    public DimensionAPI getDimensionAPI() {
        return this.dimensionAPI;
    }

    @Override
    public CustomStructureAPI getCustomStructureAPI() {
        return this.customStructureAPI;
    }

    @Override
    public CustomAssetAPI getCustomAssetAPI() {
        return this.customAssetAPI;
    }

    @Override
    public <T extends ModConfig> T getModConfig(Class<T> configClass) {
        return this.modConfigManager.getModConfig(this.modId, configClass);
    }

    @Override
    public <T extends ModConfig> T getModConfig(String modId, Class<T> configClass) {
        return this.modConfigManager.getModConfig(modId, configClass);
    }

    @Override
    public ModMessageAPI getModMessageAPI() {
        return this.modMessageAPI;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public Permissions getPermissions() {
        return this.permissions;
    }

    @Override
    public Networking getNetworking() {
        return this.networking;
    }

    @Override
    public GUIAPI getGUIAPI() {
        return this.guiAPI;
    }

    @Override
    public ProceduralGenerationAPI getProceduralGenerationAPI() {
        return this.proceduralGenerationAPI;
    }
}

