/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api;

import com.example.modloader.api.ModMessageAPI;
import com.example.modloader.api.ModMessageHandler;
import com.example.modloader.api.network.MessagePacket;
import com.example.modloader.api.network.Networking;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ModMessageAPIImpl
implements ModMessageAPI {
    private final JavaPlugin plugin;
    private final String senderModId;
    private final Networking networking;
    private final String messageChannel = "modloader:messages";
    private final Map<String, List<HandlerEntry>> messageHandlers = new ConcurrentHashMap<String, List<HandlerEntry>>();

    public ModMessageAPIImpl(JavaPlugin plugin, String senderModId, Networking networking) {
        this.plugin = plugin;
        this.senderModId = senderModId;
        this.networking = networking;
        this.networking.registerChannel("modloader:messages");
        this.networking.registerListener("modloader:messages", MessagePacket.class, this::handleNetworkPacket);
    }

    @Override
    public void sendMessage(String recipientModId, String messageType, String payload) {
        MessagePacket packet = new MessagePacket(this.senderModId, recipientModId, messageType, payload);
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.networking.sendPacket(player, "modloader:messages", packet);
        }
        this.plugin.getLogger().info("Mod " + this.senderModId + " sent message of type " + messageType + " to " + recipientModId + " via network.");
    }

    @Override
    public void broadcastMessage(String messageType, String payload) {
        MessagePacket packet = new MessagePacket(this.senderModId, null, messageType, payload);
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.networking.sendPacket(player, "modloader:messages", packet);
        }
        this.plugin.getLogger().info("Mod " + this.senderModId + " broadcasted message of type " + messageType + " via network.");
    }

    @Override
    public void sendInterServerMessage(String targetServer, String recipientModId, String messageType, String payload) {
        Player player = this.getAnyOnlinePlayer();
        if (player == null) {
            this.plugin.getLogger().warning("Cannot send inter-server message: No players online to forward the message.");
            return;
        }
        MessagePacket packet = new MessagePacket(this.senderModId, recipientModId, messageType, payload);
        this.networking.sendBungeeCordPacket(player, "Forward", targetServer, packet);
        this.plugin.getLogger().info("Mod " + this.senderModId + " sent inter-server message of type " + messageType + " to " + recipientModId + " on server " + targetServer);
    }

    @Override
    public void broadcastInterServerMessage(String messageType, String payload) {
        Player player = this.getAnyOnlinePlayer();
        if (player == null) {
            this.plugin.getLogger().warning("Cannot broadcast inter-server message: No players online to forward the message.");
            return;
        }
        MessagePacket packet = new MessagePacket(this.senderModId, null, messageType, payload);
        this.networking.sendBungeeCordPacket(player, "Forward", "ALL", packet);
        this.plugin.getLogger().info("Mod " + this.senderModId + " broadcasted inter-server message of type " + messageType + " to ALL servers.");
    }

    private Player getAnyOnlinePlayer() {
        if (this.plugin.getServer().getOnlinePlayers().isEmpty()) {
            return null;
        }
        return (Player)this.plugin.getServer().getOnlinePlayers().iterator().next();
    }

    @Override
    public void registerMessageHandler(String messageType, ModMessageHandler handler) {
        this.messageHandlers.computeIfAbsent(messageType, k -> new ArrayList()).add(new HandlerEntry(handler, this.senderModId));
        this.plugin.getLogger().info("Mod " + this.senderModId + " registered handler for message type: " + messageType);
    }

    @Override
    public void unregisterMessageHandler(String messageType, ModMessageHandler handler) {
        List<HandlerEntry> handlers = this.messageHandlers.get(messageType);
        if (handlers != null) {
            handlers.removeIf(entry -> entry.handler.equals(handler) && entry.modId.equals(this.senderModId));
            if (handlers.isEmpty()) {
                this.messageHandlers.remove(messageType);
            }
            this.plugin.getLogger().info("Mod " + this.senderModId + " unregistered handler for message type: " + messageType);
        }
    }

    private void handleNetworkPacket(MessagePacket packet) {
        if (packet.getRecipientModId() == null || packet.getRecipientModId().equals(this.senderModId)) {
            List<HandlerEntry> handlers = this.messageHandlers.get(packet.getMessageType());
            if (handlers != null) {
                List relevantHandlers = handlers.stream().filter(entry -> packet.getRecipientModId() == null || entry.modId.equals(packet.getRecipientModId())).collect(Collectors.toList());
                for (HandlerEntry entry2 : relevantHandlers) {
                    try {
                        entry2.handler.handleMessage(packet.getSenderModId(), packet.getMessageType(), packet.getPayload());
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Error handling network message for mod " + entry2.modId + " from " + packet.getSenderModId() + " type " + packet.getMessageType(), e);
                    }
                }
            } else {
                this.plugin.getLogger().warning("Received network message of type " + packet.getMessageType() + " from " + packet.getSenderModId() + " but no handler registered.");
            }
        }
    }

    public void unregisterAllHandlersForMod(String modId) {
        this.messageHandlers.forEach((messageType, handlers) -> {
            handlers.removeIf(entry -> entry.modId.equals(modId));
            if (handlers.isEmpty()) {
                this.messageHandlers.remove(messageType);
            }
        });
        this.plugin.getLogger().info("Unregistered all message handlers for mod: " + modId);
    }

    private static class HandlerEntry {
        final ModMessageHandler handler;
        final String modId;

        HandlerEntry(ModMessageHandler handler, String modId) {
            this.handler = handler;
            this.modId = modId;
        }
    }
}

