/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api.dependencyinjection;

import com.example.modloader.api.dependencyinjection.Named;
import com.example.modloader.api.dependencyinjection.Provides;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Binder {
    private final Map<BindingKey, Object> bindings = new HashMap<BindingKey, Object>();
    private final Map<BindingKey, ProviderBinding> providerBindings = new HashMap<BindingKey, ProviderBinding>();

    public <T> void bind(Class<T> type, T instance) {
        this.bind(type, instance, null);
    }

    public <T> void bind(Class<T> type, T instance, String name) {
        this.bindings.put(new BindingKey(type, name), instance);
    }

    public <T> T getInstance(Class<T> type) {
        return this.getInstance(type, null);
    }

    public <T> T getInstance(Class<T> type, String name) {
        return (T)this.bindings.get(new BindingKey(type, name));
    }

    public boolean hasBinding(Class<?> type) {
        return this.hasBinding(type, null);
    }

    public boolean hasBinding(Class<?> type, String name) {
        return this.bindings.containsKey(new BindingKey(type, name));
    }

    public void registerProviders(Object providerContainer) {
        for (Method method : providerContainer.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Provides.class)) continue;
            Class<?> returnType = method.getReturnType();
            String name = null;
            if (method.isAnnotationPresent(Named.class)) {
                name = method.getAnnotation(Named.class).value();
            }
            this.providerBindings.put(new BindingKey(returnType, name), new ProviderBinding(method, providerContainer));
        }
    }

    public ProviderBinding getProvider(Class<?> type, String name) {
        return this.providerBindings.get(new BindingKey(type, name));
    }

    public boolean hasProvider(Class<?> type, String name) {
        return this.providerBindings.containsKey(new BindingKey(type, name));
    }

    private static class BindingKey {
        private final Class<?> type;
        private final String name;

        public BindingKey(Class<?> type, String name) {
            this.type = type;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BindingKey that = (BindingKey)o;
            return this.type.equals(that.type) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.name);
        }
    }

    public static class ProviderBinding {
        private final Method method;
        private final Object instance;

        public ProviderBinding(Method method, Object instance) {
            this.method = method;
            this.instance = instance;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

