/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api.dependencyinjection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModAPIRegistry {
    private final Map<Class<?>, List<Object>> apiInstances = new HashMap();

    public <T> void registerAPI(Class<T> apiType, T instance) {
        this.apiInstances.computeIfAbsent(apiType, k -> new ArrayList()).add(instance);
    }

    public <T> T getAPI(Class<T> apiType) {
        List<Object> instances = this.apiInstances.get(apiType);
        if (instances != null && !instances.isEmpty()) {
            return (T)instances.get(0);
        }
        return null;
    }

    public <T> List<T> getAPIs(Class<T> apiType) {
        List<Object> instances = this.apiInstances.get(apiType);
        if (instances != null) {
            return new ArrayList<Object>(instances);
        }
        return new ArrayList();
    }

    public boolean hasAPI(Class<?> apiType) {
        return this.apiInstances.containsKey(apiType) && !this.apiInstances.get(apiType).isEmpty();
    }
}

