/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api.dependencyinjection;

import com.example.modloader.api.dependencyinjection.Binder;
import com.example.modloader.api.dependencyinjection.ModAPIRegistry;
import com.example.modloader.api.dependencyinjection.Named;
import com.example.modloader.api.dependencyinjection.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ModInjector {
    private final Binder binder;
    private final ModAPIRegistry apiRegistry;
    private final Map<Class<?>, Object> singletons = new ConcurrentHashMap();

    public ModInjector(Binder binder, ModAPIRegistry apiRegistry) {
        this.binder = binder;
        this.apiRegistry = apiRegistry;
    }

    public <T> T createInstance(Class<T> type) throws Exception {
        return this.createInstance(type, null);
    }

    public <T> T createInstance(Class<T> type, String name) throws Exception {
        Object instance;
        if (type.isAnnotationPresent(Singleton.class) && (instance = this.singletons.get(type)) != null) {
            return (T)instance;
        }
        if (this.binder.hasBinding(type, name)) {
            return this.binder.getInstance(type, name);
        }
        if (this.binder.hasProvider(type, name)) {
            Binder.ProviderBinding provider = this.binder.getProvider(type, name);
            Method method = provider.getMethod();
            ArrayList parameters = new ArrayList();
            for (Class<?> parameterType : method.getParameterTypes()) {
                parameters.add(this.createInstance(parameterType));
            }
            Object instance2 = method.invoke(provider.getInstance(), parameters.toArray());
            if (type.isAnnotationPresent(Singleton.class)) {
                this.singletons.put(type, instance2);
            }
            return (T)instance2;
        }
        if (this.apiRegistry.hasAPI(type)) {
            return this.apiRegistry.getAPI(type);
        }
        Constructor<?>[] constructors = type.getConstructors();
        if (constructors.length == 0) {
            T instance3 = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (type.isAnnotationPresent(Singleton.class)) {
                this.singletons.put(type, instance3);
            }
            return instance3;
        }
        Constructor<?> constructor = constructors[0];
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        ArrayList<List<Object>> parameters = new ArrayList<List<Object>>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class apiListType;
            ParameterizedType pType;
            Type[] actualTypeArguments;
            Type genericParameterType;
            Class<?> parameterType = parameterTypes[i];
            String paramName = null;
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof Named)) continue;
                paramName = ((Named)annotation).value();
                break;
            }
            if (List.class.isAssignableFrom(parameterType) && (genericParameterType = constructor.getGenericParameterTypes()[i]) instanceof ParameterizedType && (actualTypeArguments = (pType = (ParameterizedType)genericParameterType).getActualTypeArguments()).length == 1 && actualTypeArguments[0] instanceof Class && this.apiRegistry.hasAPI(apiListType = (Class)actualTypeArguments[0])) {
                parameters.add(this.apiRegistry.getAPIs(apiListType));
                continue;
            }
            parameters.add((List<Object>)this.createInstance(parameterType, paramName));
        }
        Object instance4 = constructor.newInstance(parameters.toArray());
        if (type.isAnnotationPresent(Singleton.class)) {
            this.singletons.put(type, instance4);
        }
        return (T)instance4;
    }
}

