/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api.gui;

import com.example.modloader.api.gui.Component;
import com.example.modloader.api.gui.Layout;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class GUI {
    private final String title;
    private final int size;
    private final Layout layout;
    private final Map<Component, Object> componentConstraints = new HashMap<Component, Object>();
    private Map<Integer, Component> arrangedComponents = new HashMap<Integer, Component>();
    private Inventory inventory;

    public GUI(String title, int size, Layout layout) {
        this.title = title;
        this.size = size;
        this.layout = layout;
    }

    public void addComponent(Component component, Object constraints) {
        this.componentConstraints.put(component, constraints);
    }

    public void open(Player player) {
        this.arrangedComponents = this.layout.arrangeComponents(this.componentConstraints);
        this.inventory = Bukkit.createInventory(null, (int)this.size, (String)this.title);
        for (Map.Entry<Integer, Component> entry : this.arrangedComponents.entrySet()) {
            this.inventory.setItem(entry.getKey().intValue(), entry.getValue().getItemStack());
        }
        player.openInventory(this.inventory);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Component getComponent(int slot) {
        return this.arrangedComponents.get(slot);
    }

    public void updateComponent(Component component, Object constraints) {
        this.componentConstraints.put(component, constraints);
        this.arrangedComponents = this.layout.arrangeComponents(this.componentConstraints);
        if (this.inventory != null) {
            this.inventory.clear();
            for (Map.Entry<Integer, Component> entry : this.arrangedComponents.entrySet()) {
                this.inventory.setItem(entry.getKey().intValue(), entry.getValue().getItemStack());
            }
        }
    }

    public void removeComponent(Component component) {
        this.componentConstraints.remove(component);
        this.arrangedComponents = this.layout.arrangeComponents(this.componentConstraints);
        if (this.inventory != null) {
            this.inventory.clear();
            for (Map.Entry<Integer, Component> entry : this.arrangedComponents.entrySet()) {
                this.inventory.setItem(entry.getKey().intValue(), entry.getValue().getItemStack());
            }
        }
    }
}

