/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api.gui;

import com.example.modloader.api.gui.Component;
import com.example.modloader.api.gui.Layout;
import java.util.HashMap;
import java.util.Map;

public class GridLayout
implements Layout {
    private final int rows;
    private final int cols;

    public GridLayout(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
    }

    @Override
    public Map<Integer, Component> arrangeComponents(Map<Component, Object> componentConstraints) {
        HashMap<Integer, Component> arranged = new HashMap<Integer, Component>();
        for (Map.Entry<Component, Object> entry : componentConstraints.entrySet()) {
            Component component = entry.getKey();
            GridConstraints constraints = (GridConstraints)entry.getValue();
            int slot = constraints.getRow() * this.cols + constraints.getCol();
            arranged.put(slot, component);
        }
        return arranged;
    }

    public static class GridConstraints {
        private final int row;
        private final int col;

        public GridConstraints(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }
    }
}

