/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.api.network;

import com.example.modloader.api.network.Packet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class Networking
implements PluginMessageListener {
    private final JavaPlugin plugin;
    private final Map<String, Map<Class<? extends Packet>, List<Consumer<? extends Packet>>>> channelPacketListeners = new ConcurrentHashMap<String, Map<Class<? extends Packet>, List<Consumer<? extends Packet>>>>();
    private final Set<String> registeredChannels = ConcurrentHashMap.newKeySet();

    public Networking(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerChannel(String channelName) {
        if (this.registeredChannels.add(channelName)) {
            this.plugin.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, channelName, (PluginMessageListener)this);
            this.plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, channelName);
            this.plugin.getLogger().info("Registered network channel: " + channelName);
        }
    }

    public void unregisterChannel(String channelName) {
        if (this.registeredChannels.remove(channelName)) {
            this.plugin.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this.plugin, channelName, (PluginMessageListener)this);
            this.plugin.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this.plugin, channelName);
            this.channelPacketListeners.remove(channelName);
            this.plugin.getLogger().info("Unregistered network channel: " + channelName);
        }
    }

    public <T extends Packet> void registerListener(String channelName, Class<T> packetType, Consumer<T> listener) {
        if (!this.registeredChannels.contains(channelName)) {
            this.plugin.getLogger().warning("Attempted to register listener for unregistered channel: " + channelName + ". Registering channel now.");
            this.registerChannel(channelName);
        }
        this.channelPacketListeners.computeIfAbsent(channelName, k -> new ConcurrentHashMap()).computeIfAbsent(packetType, k -> new ArrayList()).add(listener);
    }

    public <T extends Packet> void unregisterListener(String channelName, Class<T> packetType, Consumer<T> listener) {
        Map<Class<? extends Packet>, List<Consumer<? extends Packet>>> packetListeners = this.channelPacketListeners.get(channelName);
        if (packetListeners != null) {
            List<Consumer<? extends Packet>> listeners = packetListeners.get(packetType);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    packetListeners.remove(packetType);
                }
            }
            if (packetListeners.isEmpty()) {
                this.channelPacketListeners.remove(channelName);
            }
        }
    }

    public void sendPacket(Player player, String channelName, Packet packet) {
        if (!this.registeredChannels.contains(channelName)) {
            this.plugin.getLogger().warning("Attempted to send packet on unregistered channel: " + channelName + ". Packet will not be sent.");
            return;
        }
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(packet);
            objectStream.flush();
            player.sendPluginMessage((Plugin)this.plugin, channelName, byteStream.toByteArray());
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to send packet on channel " + channelName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void sendBungeeCordPacket(Player player, String subChannel, String serverName, Packet packet) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteStream);
            out.writeUTF(subChannel);
            out.writeUTF(serverName);
            ByteArrayOutputStream packetByteStream = new ByteArrayOutputStream();
            ObjectOutputStream packetObjectStream = new ObjectOutputStream(packetByteStream);
            packetObjectStream.writeObject(packet);
            packetObjectStream.flush();
            out.writeShort(packetByteStream.toByteArray().length);
            out.write(packetByteStream.toByteArray());
            player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", byteStream.toByteArray());
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to send BungeeCord packet on subchannel " + subChannel + " to server " + serverName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void onPluginMessageReceived(String channelName, Player player, byte[] message) {
        Map<Class<? extends Packet>, List<Consumer<? extends Packet>>> packetListeners = this.channelPacketListeners.get(channelName);
        if (packetListeners == null) {
            return;
        }
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(message);
            ObjectInputStream objectStream = new ObjectInputStream(byteStream);
            Packet packet = (Packet)objectStream.readObject();
            List<Consumer<? extends Packet>> listeners = packetListeners.get(packet.getClass());
            if (listeners != null) {
                for (Consumer<? extends Packet> listener : listeners) {
                    try {
                        listener.accept(packet);
                    }
                    catch (ClassCastException e) {
                        this.plugin.getLogger().severe("Packet type mismatch for channel " + channelName + ". Expected " + packet.getClass().getName() + ", but listener expects different type.");
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().severe("Error dispatching packet on channel " + channelName + ": " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            this.plugin.getLogger().severe("Failed to receive or deserialize packet on channel " + channelName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void shutdown() {
        for (String channelName : new ArrayList<String>(this.registeredChannels)) {
            this.unregisterChannel(channelName);
        }
        this.channelPacketListeners.clear();
    }
}

