/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader.gui;

import com.example.modloader.ModInfo;
import com.example.modloader.ModLoaderService;
import com.example.modloader.ModState;
import com.example.modloader.api.gui.Component;
import com.example.modloader.api.gui.GUI;
import com.example.modloader.api.gui.GridLayout;
import com.example.modloader.api.gui.Label;
import com.example.modloader.api.gui.SimpleButton;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class ModManagementGUI
extends GUI {
    private final JavaPlugin plugin;
    private final ModLoaderService modLoaderService;
    private final Map<String, Component> modStatusLabels = new ConcurrentHashMap<String, Component>();
    private final Map<String, Component> modActionButtons = new ConcurrentHashMap<String, Component>();

    public ModManagementGUI(JavaPlugin plugin, ModLoaderService modLoaderService) {
        super("Mod Management", 54, new GridLayout(9, 6));
        this.plugin = plugin;
        this.modLoaderService = modLoaderService;
        this.initializeGUI();
    }

    private void initializeGUI() {
        int slot = 0;
        for (ModInfo modInfo : this.modLoaderService.getLoadedModsInfo()) {
            this.addComponent(new Label(this.createModInfoItem(modInfo)), new GridLayout.GridConstraints(slot, 0));
            this.modStatusLabels.put(modInfo.getId(), new Label(this.createModStatusItem(modInfo)));
            this.addComponent(this.modStatusLabels.get(modInfo.getId()), new GridLayout.GridConstraints(slot, 1));
            SimpleButton toggleButton = new SimpleButton(this.createToggleButtonItem(modInfo), player -> {
                try {
                    if (modInfo.getState() == ModState.ENABLED) {
                        this.modLoaderService.disableMod(modInfo.getName());
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Mod '" + modInfo.getName() + "' disabled.");
                    } else {
                        this.modLoaderService.enableMod(modInfo.getName());
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Mod '" + modInfo.getName() + "' enabled.");
                    }
                    this.updateModStatus(modInfo);
                }
                catch (Exception e) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Error toggling mod '" + modInfo.getName() + "': " + e.getMessage());
                    this.plugin.getLogger().severe("Error toggling mod '" + modInfo.getName() + "': " + e.getMessage());
                }
            });
            this.modActionButtons.put(modInfo.getId(), toggleButton);
            this.addComponent(toggleButton, new GridLayout.GridConstraints(slot, 2));
            ++slot;
        }
    }

    private ItemStack createModInfoItem(ModInfo modInfo) {
        ItemStack item = new ItemStack(Material.BOOK);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.GOLD) + modInfo.getName() + " v" + modInfo.getVersion());
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Author: " + modInfo.getAuthor())));
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Description: " + modInfo.getDescription())));
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Status: " + modInfo.getState().name())));
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createModStatusItem(ModInfo modInfo) {
        Material statusMaterial = modInfo.getState() == ModState.ENABLED ? Material.LIME_DYE : Material.GRAY_DYE;
        String statusName = modInfo.getState() == ModState.ENABLED ? String.valueOf(ChatColor.GREEN) + "ENABLED" : String.valueOf(ChatColor.RED) + "DISABLED";
        ItemStack item = new ItemStack(statusMaterial);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(statusName);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createToggleButtonItem(ModInfo modInfo) {
        Material buttonMaterial = modInfo.getState() == ModState.ENABLED ? Material.REDSTONE_BLOCK : Material.EMERALD_BLOCK;
        String buttonName = modInfo.getState() == ModState.ENABLED ? String.valueOf(ChatColor.RED) + "Disable" : String.valueOf(ChatColor.GREEN) + "Enable";
        ItemStack item = new ItemStack(buttonMaterial);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(buttonName);
        item.setItemMeta(meta);
        return item;
    }

    private void updateModStatus(ModInfo modInfo) {
        SimpleButton toggleButton;
        Label statusLabel = (Label)this.modStatusLabels.get(modInfo.getId());
        if (statusLabel != null) {
            statusLabel.setItemStack(this.createModStatusItem(modInfo));
        }
        if ((toggleButton = (SimpleButton)this.modActionButtons.get(modInfo.getId())) != null) {
            toggleButton.setItemStack(this.createToggleButtonItem(modInfo));
        }
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            if (!player.getOpenInventory().getTopInventory().equals((Object)this.getInventory())) continue;
            this.open(player);
        }
    }
}

