/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.api.ModCommandExecutor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

public class CustomCommandRegistry {
    private final Plugin plugin;
    private final Logger logger;
    private CommandMap commandMap;
    private final List<String> registeredCommandNames = new ArrayList<String>();

    public CustomCommandRegistry(Plugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        try {
            if (plugin.getServer().getPluginManager() instanceof SimplePluginManager) {
                Field f = SimplePluginManager.class.getDeclaredField("commandMap");
                f.setAccessible(true);
                this.commandMap = (CommandMap)f.get(plugin.getServer().getPluginManager());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.logger.severe("Failed to get Bukkit CommandMap: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void register(String commandName, final ModCommandExecutor modExecutor) {
        if (this.commandMap == null) {
            this.logger.warning("CommandMap not available, cannot register command: " + commandName);
            return;
        }
        Command bukkitCommand = new Command(commandName){

            public boolean execute(CommandSender sender, String commandLabel, String[] args) {
                return modExecutor.onCommand(sender, commandLabel, args);
            }

            public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
                List completions = modExecutor.onTabComplete(sender, alias, args);
                return completions != null ? completions : super.tabComplete(sender, alias, args);
            }
        };
        this.commandMap.register(this.plugin.getName(), bukkitCommand);
        this.registeredCommandNames.add(commandName);
        this.logger.info("Registered custom command: /" + commandName);
    }

    public void unregisterAll() {
        if (this.commandMap == null) {
            return;
        }
        for (String commandName : this.registeredCommandNames) {
            Command command = this.commandMap.getCommand(commandName);
            if (command == null) continue;
            command.unregister(this.commandMap);
            this.logger.info("Unregistered custom command: /" + commandName);
        }
        this.registeredCommandNames.clear();
    }
}

