/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class CustomEventListenerRegistry {
    private final Plugin plugin;
    private final Logger logger;
    private final PluginManager pluginManager;
    private final List<Listener> registeredListeners = new ArrayList<Listener>();

    public CustomEventListenerRegistry(Plugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.pluginManager = plugin.getServer().getPluginManager();
    }

    public void register(Listener listener) {
        this.pluginManager.registerEvents(listener, this.plugin);
        this.registeredListeners.add(listener);
        this.logger.info("Registered custom event listener: " + listener.getClass().getName());
    }

    public void unregisterAll() {
        for (Listener listener : this.registeredListeners) {
            HandlerList.unregisterAll((Listener)listener);
            this.logger.info("Unregistered custom event listener: " + listener.getClass().getName());
        }
        this.registeredListeners.clear();
    }
}

