/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.api.CustomWorldPopulator;
import com.example.modloader.api.world.CustomOreGenerator;
import com.example.modloader.api.world.CustomStructureGenerator;
import com.example.modloader.api.world.CustomTreeGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.plugin.Plugin;

public class CustomWorldGeneratorRegistry {
    private final Plugin plugin;
    private final Logger logger;
    private final List<CustomWorldPopulator> registeredPopulators = new ArrayList<CustomWorldPopulator>();
    private final List<CustomOreGenerator> registeredOreGenerators = new ArrayList<CustomOreGenerator>();
    private final List<CustomTreeGenerator> registeredTreeGenerators = new ArrayList<CustomTreeGenerator>();
    private final List<CustomStructureGenerator> registeredStructureGenerators = new ArrayList<CustomStructureGenerator>();

    public CustomWorldGeneratorRegistry(Plugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public void registerPopulator(CustomWorldPopulator populator) {
        this.registeredPopulators.add(populator);
        this.logger.info("Registered custom world populator: " + populator.getClass().getName());
    }

    public void registerOreGenerator(CustomOreGenerator generator) {
        this.registeredOreGenerators.add(generator);
        this.logger.info("Registered custom ore generator: " + generator.getClass().getName());
    }

    public void registerTreeGenerator(CustomTreeGenerator generator) {
        this.registeredTreeGenerators.add(generator);
        this.logger.info("Registered custom tree generator: " + generator.getClass().getName());
    }

    public void registerStructureGenerator(CustomStructureGenerator generator) {
        this.registeredStructureGenerators.add(generator);
        this.logger.info("Registered custom structure generator: " + generator.getClass().getName());
    }

    public void applyPopulatorsToWorld(World world) {
        for (final CustomWorldPopulator customPopulator : this.registeredPopulators) {
            world.getPopulators().add(new BlockPopulator(){

                public void populate(World world, Random random, Chunk chunk) {
                    customPopulator.populate(world, random, chunk);
                }
            });
            this.logger.info("Applied populator " + customPopulator.getClass().getName() + " to world " + world.getName());
        }
        world.getPopulators().add(new BlockPopulator(){

            public void populate(World world, Random random, Chunk chunk) {
                for (CustomOreGenerator generator : CustomWorldGeneratorRegistry.this.registeredOreGenerators) {
                    generator.generate(world, random, chunk.getX(), chunk.getZ());
                }
            }
        });
        world.getPopulators().add(new BlockPopulator(){

            public void populate(World world, Random random, Chunk chunk) {
                for (CustomTreeGenerator generator : CustomWorldGeneratorRegistry.this.registeredTreeGenerators) {
                    int x = chunk.getX() * 16 + random.nextInt(16);
                    int z = chunk.getZ() * 16 + random.nextInt(16);
                    int y = world.getHighestBlockYAt(x, z);
                    generator.generate(world, random, x, y, z);
                }
            }
        });
        world.getPopulators().add(new BlockPopulator(){

            public void populate(World world, Random random, Chunk chunk) {
                for (CustomStructureGenerator generator : CustomWorldGeneratorRegistry.this.registeredStructureGenerators) {
                    int x = chunk.getX() * 16 + random.nextInt(16);
                    int z = chunk.getZ() * 16 + random.nextInt(16);
                    int y = world.getHighestBlockYAt(x, z);
                    generator.generate(world, random, new Location(world, (double)x, (double)y, (double)z));
                }
            }
        });
    }

    public void unregisterAll() {
        this.registeredPopulators.clear();
        this.registeredOreGenerators.clear();
        this.registeredTreeGenerators.clear();
        this.registeredStructureGenerators.clear();
        this.logger.info("Unregistered all custom world populator, ore, tree, and structure generator definitions.");
    }
}

