/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.ModLoaderCommandExecutor;
import com.example.modloader.ModLoaderService;
import com.example.modloader.PlayerJoinListener;
import com.example.modloader.ResourcePackGenerator;
import com.example.modloader.WebServer;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ModLoader
extends JavaPlugin {
    private ModLoaderService modLoaderService;
    private ResourcePackGenerator resourcePackGenerator;
    private WebServer webServer;

    public void onEnable() {
        this.getLogger().info("ModLoader plugin is enabling!");
        File modsFolder = new File(this.getDataFolder(), "Mods");
        if (!modsFolder.exists()) {
            if (modsFolder.mkdirs()) {
                this.getLogger().info("Created Mods folder at: " + modsFolder.getPath());
            } else {
                this.getLogger().severe("Failed to create Mods folder!");
                return;
            }
        }
        this.modLoaderService = new ModLoaderService(this);
        this.resourcePackGenerator = new ResourcePackGenerator(this);
        this.modLoaderService.loadModsAndGeneratePack();
        if (!this.resourcePackGenerator.generate()) {
            this.getLogger().severe("Could not generate resource pack. Aborting resource pack server startup.");
            return;
        }
        this.saveDefaultConfig();
        int webServerPort = this.getConfig().getInt("web-server-port", 25566);
        this.webServer = new WebServer(this, this.resourcePackGenerator.getZipFile(), webServerPort);
        this.webServer.start();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this, this.webServer, this.resourcePackGenerator), (Plugin)this);
        this.getCommand("modloader").setExecutor((CommandExecutor)new ModLoaderCommandExecutor(this, this.modLoaderService));
        this.getCommand("modloader").setTabCompleter((TabCompleter)new ModLoaderCommandExecutor(this, this.modLoaderService));
    }

    public void onDisable() {
        this.getLogger().info("ModLoader plugin is disabling!");
        if (this.webServer != null) {
            this.webServer.stop();
        }
        if (this.modLoaderService != null) {
            this.modLoaderService.disableMods();
        }
    }
}

