/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.ModInfo;
import com.example.modloader.ModLoaderService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ModLoaderCommandExecutor
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private final ModLoaderService modLoaderService;

    public ModLoaderCommandExecutor(JavaPlugin plugin, ModLoaderService modLoaderService) {
        this.plugin = plugin;
        this.modLoaderService = modLoaderService;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "list": {
                this.handleListCommand(sender);
                break;
            }
            case "info": {
                this.handleInfoCommand(sender, args);
                break;
            }
            case "reload": {
                if (!sender.hasPermission("modloader.reload")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                    return true;
                }
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Reloading ModLoader999 mods...");
                this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    this.modLoaderService.disableMods();
                    this.modLoaderService.loadModsAndGeneratePack();
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "ModLoader999 mods reloaded successfully!");
                });
                break;
            }
            case "enable": {
                if (!sender.hasPermission("modloader.enable")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /modloader enable <modName>");
                    return true;
                }
                String modToEnable = args[1];
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Attempting to enable mod: " + modToEnable + "...");
                this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    try {
                        this.modLoaderService.enableMod(modToEnable);
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Mod '" + modToEnable + "' enabled successfully!");
                    }
                    catch (Exception e) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to enable mod '" + modToEnable + "': " + e.getMessage());
                        this.plugin.getLogger().severe("Error enabling mod '" + modToEnable + "': " + e.getMessage());
                        e.printStackTrace();
                    }
                });
                break;
            }
            case "disable": {
                if (!sender.hasPermission("modloader.disable")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /modloader disable <modName>");
                    return true;
                }
                String modToDisable = args[1];
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Attempting to disable mod: " + modToDisable + "...");
                this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    try {
                        this.modLoaderService.disableMod(modToDisable);
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Mod '" + modToDisable + "' disabled successfully!");
                    }
                    catch (Exception e) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to disable mod '" + modToDisable + "': " + e.getMessage());
                        this.plugin.getLogger().severe("Error disabling mod '" + modToDisable + "': " + e.getMessage());
                        e.printStackTrace();
                    }
                });
                break;
            }
            case "unload": {
                this.handleUnloadCommand(sender, args);
                break;
            }
            case "load": {
                this.handleLoadCommand(sender, args);
                break;
            }
            case "help": {
                this.sendHelpMessage(sender);
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command. Use /modloader help.");
            }
        }
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- ModLoader999 ---");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/modloader list" + String.valueOf(ChatColor.GRAY) + " - List loaded mods.");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/modloader info <modName>" + String.valueOf(ChatColor.GRAY) + " - Show detailed info about a mod.");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/modloader reload" + String.valueOf(ChatColor.GRAY) + " - Reload all mods.");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/modloader enable <modName>" + String.valueOf(ChatColor.GRAY) + " - Enable a disabled mod.");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/modloader disable <modName>" + String.valueOf(ChatColor.GRAY) + " - Disable an enabled mod.");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/modloader unload <modName>" + String.valueOf(ChatColor.GRAY) + " - Unload a mod temporarily.");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/modloader load <modName>" + String.valueOf(ChatColor.GRAY) + " - Load a previously unloaded mod.");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/modloader help" + String.valueOf(ChatColor.GRAY) + " - Show this help.");
    }

    private void handleListCommand(CommandSender sender) {
        List<ModInfo> loadedMods = this.modLoaderService.getLoadedModsInfo();
        if (loadedMods.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "No mods currently loaded.");
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Loaded Mods (" + loadedMods.size() + ") ---");
        for (ModInfo mod : loadedMods) {
            String status = this.modLoaderService.isModEnabled(mod.getName()) ? String.valueOf(ChatColor.GREEN) + "[ENABLED]" : String.valueOf(ChatColor.RED) + "[DISABLED]";
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + mod.getName() + String.valueOf(ChatColor.GRAY) + " v" + mod.getVersion() + " by " + mod.getAuthor() + " " + status);
            if (mod.getDependencies().isEmpty()) continue;
            sender.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "  Dependencies: " + String.join((CharSequence)", ", mod.getDependencies().keySet()));
        }
    }

    private void handleInfoCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("modloader.info")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /modloader info <modName>");
            return;
        }
        String modName = args[1];
        ModInfo modInfo = this.modLoaderService.getModInfo(modName);
        if (modInfo == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Mod '" + modName + "' not found.");
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Mod Info: " + modInfo.getName() + " ---");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Version: " + String.valueOf(ChatColor.WHITE) + modInfo.getVersion());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Author: " + String.valueOf(ChatColor.WHITE) + modInfo.getAuthor());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Main Class: " + String.valueOf(ChatColor.WHITE) + modInfo.getMainClass());
        String status = this.modLoaderService.isModEnabled(modName) ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled";
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Status: " + status);
        if (!modInfo.getDependencies().isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Dependencies:");
            for (Map.Entry<String, String> entry : modInfo.getDependencies().entrySet()) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "  - " + entry.getKey() + " (v" + entry.getValue() + ")");
            }
        } else {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Dependencies: " + String.valueOf(ChatColor.WHITE) + "None");
        }
    }

    private void handleUnloadCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("modloader.unload")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /modloader unload <modName>");
            return;
        }
        String modToUnload = args[1];
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Attempting to unload mod: " + modToUnload + "...");
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.modLoaderService.unloadMod(modToUnload);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Mod '" + modToUnload + "' unloaded successfully!");
            }
            catch (Exception e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to unload mod '" + modToUnload + "': " + e.getMessage());
                this.plugin.getLogger().severe("Error unloading mod '" + modToUnload + "': " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    private void handleLoadCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("modloader.load")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /modloader load <modName>");
            return;
        }
        String modToLoad = args[1];
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Attempting to load mod: " + modToLoad + "...");
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.modLoaderService.loadMod(modToLoad);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Mod '" + modToLoad + "' loaded successfully!");
            }
            catch (Exception e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to load mod '" + modToLoad + "': " + e.getMessage());
                this.plugin.getLogger().severe("Error loading mod '" + modToLoad + "': " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList completions = new ArrayList();
        if (args.length == 1) {
            return Arrays.asList("list", "info", "reload", "enable", "disable", "unload", "load", "help").stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String subCommand = args[0].toLowerCase();
            if (subCommand.equals("enable") || subCommand.equals("load")) {
                return this.modLoaderService.getAvailableModNames().stream().filter(modName -> !this.modLoaderService.isModEnabled((String)modName)).filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (subCommand.equals("disable") || subCommand.equals("unload") || subCommand.equals("info")) {
                return this.modLoaderService.getEnabledModNames().stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }
}

