/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import com.example.modloader.CustomBlockRegistry;
import com.example.modloader.CustomCommandRegistry;
import com.example.modloader.CustomEventListenerRegistry;
import com.example.modloader.CustomItemRegistry;
import com.example.modloader.CustomMobRegistry;
import com.example.modloader.CustomRecipeRegistry;
import com.example.modloader.CustomWorldGeneratorRegistry;
import com.example.modloader.ModInfo;
import com.example.modloader.api.ModAPI;
import com.example.modloader.api.ModAPIImpl;
import com.example.modloader.api.ModInitializer;
import com.github.zafarkhaja.semver.Version;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ModLoaderService {
    private final JavaPlugin plugin;
    private final CustomItemRegistry itemRegistry;
    private final CustomMobRegistry mobRegistry;
    private final CustomBlockRegistry blockRegistry;
    private final CustomCommandRegistry commandRegistry;
    private final CustomEventListenerRegistry eventListenerRegistry;
    private final CustomRecipeRegistry recipeRegistry;
    private final CustomWorldGeneratorRegistry worldGeneratorRegistry;
    private final ModAPI modAPI;
    private final File resourceStagingDir;
    private final Map<String, ModInfo> availableMods = new HashMap<String, ModInfo>();
    private final List<ModInfo> loadOrder = new LinkedList<ModInfo>();

    public ModLoaderService(JavaPlugin plugin) {
        this.plugin = plugin;
        this.itemRegistry = new CustomItemRegistry((Plugin)plugin);
        this.mobRegistry = new CustomMobRegistry((Plugin)plugin);
        this.blockRegistry = new CustomBlockRegistry((Plugin)plugin);
        this.commandRegistry = new CustomCommandRegistry((Plugin)plugin);
        this.eventListenerRegistry = new CustomEventListenerRegistry((Plugin)plugin);
        this.recipeRegistry = new CustomRecipeRegistry((Plugin)plugin);
        this.worldGeneratorRegistry = new CustomWorldGeneratorRegistry((Plugin)plugin);
        this.modAPI = new ModAPIImpl(this.itemRegistry, this.mobRegistry, this.blockRegistry, this.commandRegistry, this.eventListenerRegistry, this.recipeRegistry, this.worldGeneratorRegistry);
        this.resourceStagingDir = new File(plugin.getDataFolder(), "resource-pack-staging");
    }

    public void loadModsAndGeneratePack() {
        if (this.resourceStagingDir.exists()) {
            this.deleteDirectory(this.resourceStagingDir);
        }
        if (!this.resourceStagingDir.mkdirs()) {
            this.plugin.getLogger().severe("Failed to create resource pack staging directory.");
            return;
        }
        File modsFolder = new File(this.plugin.getDataFolder(), "Mods");
        if (!modsFolder.exists() || !modsFolder.isDirectory()) {
            this.plugin.getLogger().warning("Mods folder not found, skipping mod loading.");
            return;
        }
        File[] modFiles = modsFolder.listFiles((dir, name) -> name.endsWith(".modloader999"));
        if (modFiles == null || modFiles.length == 0) {
            this.plugin.getLogger().info("No .modloader999 mods found to load.");
            return;
        }
        File[] fileArray = modFiles;
        int n = modFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File modFile = fileArray[n2];
            try {
                this.scanModloader999(modFile);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to scan mod: " + modFile.getName());
                e.printStackTrace();
            }
            ++n2;
        }
        if (this.availableMods.isEmpty()) {
            this.plugin.getLogger().info("No valid .modloader999 mods found after scanning.");
            return;
        }
        try {
            this.resolveDependenciesAndLoad();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to resolve mod dependencies or load mods: " + e.getMessage());
            e.printStackTrace();
            this.disableMods();
            return;
        }
        this.plugin.getLogger().info("Finished processing mods. Resource pack assets staged.");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanModloader999(File modFile) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JarFile jarFile = new JarFile(modFile);){
            void var10_10;
            String mainClassName;
            String modAuthor;
            String modVersion;
            String modName;
            block23: {
                JarEntry modInfoEntry = jarFile.getJarEntry("modinfo.json");
                if (modInfoEntry == null) {
                    this.plugin.getLogger().warning("Mod " + modFile.getName() + " is missing modinfo.json. Skipping.");
                    return;
                }
                HashMap hashMap = new HashMap();
                Throwable throwable2 = null;
                Object var12_13 = null;
                try {
                    InputStream is = jarFile.getInputStream(modInfoEntry);
                    try {
                        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                            Gson gson = new Gson();
                            JsonObject modInfoJson = gson.fromJson((Reader)reader, JsonObject.class);
                            modName = modInfoJson.get("name").getAsString();
                            modVersion = modInfoJson.get("version").getAsString();
                            modAuthor = modInfoJson.get("author").getAsString();
                            mainClassName = modInfoJson.get("main").getAsString();
                            if (modInfoJson.has("dependencies")) {
                                JsonObject depsObject = modInfoJson.getAsJsonObject("dependencies");
                                Type type = new TypeToken<Map<String, String>>(){}.getType();
                                Map map = (Map)gson.fromJson((JsonElement)depsObject, type);
                            }
                        }
                        if (is == null) break block23;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        if (is == null) throw throwable2;
                        is.close();
                        throw throwable2;
                    }
                    is.close();
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            ModInfo modInfo = new ModInfo(modName, modVersion, modAuthor, mainClassName, (Map<String, String>)var10_10, modFile);
            this.availableMods.put(modName, modInfo);
            this.plugin.getLogger().info("Scanned mod: " + modName + " v" + modVersion + " by " + modAuthor);
            jarFile.stream().forEach(entry -> {
                String entryName = entry.getName();
                if (!entry.isDirectory() && entryName.startsWith("assets/")) {
                    try {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (InputStream entryIs = jarFile.getInputStream((ZipEntry)entry);){
                            this.extractResource(entryName, entryIs);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().severe("Failed to extract resource " + entryName + " from " + modFile.getName());
                        e.printStackTrace();
                    }
                }
            });
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    private void resolveDependenciesAndLoad() throws Exception {
        HashMap graph = new HashMap();
        HashMap<String, Integer> inDegree = new HashMap<String, Integer>();
        for (ModInfo mod : this.availableMods.values()) {
            graph.put(mod.getName(), new HashSet());
            inDegree.put(mod.getName(), 0);
        }
        for (ModInfo mod : this.availableMods.values()) {
            for (Map.Entry<String, String> entry : mod.getDependencies().entrySet()) {
                String dependencyName = entry.getKey();
                String requiredVersionRange = entry.getValue();
                if (!this.availableMods.containsKey(dependencyName)) {
                    throw new Exception("Mod '" + mod.getName() + "' depends on unknown mod '" + dependencyName + "'");
                }
                ModInfo dependencyMod = this.availableMods.get(dependencyName);
                Version dependencyVersion = Version.valueOf(dependencyMod.getVersion());
                if (!dependencyVersion.satisfies(requiredVersionRange)) {
                    throw new Exception("Mod '" + mod.getName() + "' requires version " + requiredVersionRange + " of mod '" + dependencyName + "', but version " + dependencyMod.getVersion() + " is present.");
                }
                ((Set)graph.get(dependencyName)).add(mod.getName());
                inDegree.put(mod.getName(), (Integer)inDegree.get(mod.getName()) + 1);
            }
        }
        LinkedList<ModInfo> queue = new LinkedList<ModInfo>();
        for (ModInfo mod : this.availableMods.values()) {
            if ((Integer)inDegree.get(mod.getName()) == 0) {
                queue.add(mod);
                continue;
            }
            this.plugin.getLogger().info("Mod '" + mod.getName() + "' has in-degree " + String.valueOf(inDegree.get(mod.getName())) + ".");
        }
        int count = 0;
        while (!queue.isEmpty()) {
            ModInfo modInfo = (ModInfo)queue.removeFirst();
            this.loadOrder.add(modInfo);
            ++count;
            for (String dependentModName : (Set)graph.get(modInfo.getName())) {
                inDegree.put(dependentModName, (Integer)inDegree.get(dependentModName) - 1);
                if ((Integer)inDegree.get(dependentModName) != 0) continue;
                queue.add(this.availableMods.get(dependentModName));
            }
        }
        if (count != this.availableMods.size()) {
            HashSet<String> hashSet = new HashSet<String>(this.availableMods.keySet());
            for (ModInfo loadedMod : this.loadOrder) {
                hashSet.remove(loadedMod.getName());
            }
            throw new Exception("Circular dependency detected among mods: " + String.valueOf(hashSet));
        }
        for (ModInfo modInfo : this.loadOrder) {
            this.plugin.getLogger().info("Loading mod: " + modInfo.getName() + " v" + modInfo.getVersion());
            this.loadModloader999(modInfo);
        }
    }

    private void loadModloader999(ModInfo modInfo) throws Exception {
        URL[] urls = new URL[]{modInfo.getModFile().toURI().toURL()};
        URLClassLoader classLoader = new URLClassLoader(urls, this.plugin.getClass().getClassLoader());
        modInfo.setClassLoader(classLoader);
        Throwable throwable = null;
        Object var5_6 = null;
        try (JarFile jarFile = new JarFile(modInfo.getModFile());){
            Class<?> mainClass = classLoader.loadClass(modInfo.getMainClass());
            if (ModInitializer.class.isAssignableFrom(mainClass) && !mainClass.isInterface()) {
                this.plugin.getLogger().info("Found ModInitializer: " + mainClass.getName() + " for mod " + modInfo.getName());
                ModInitializer modInitializer = (ModInitializer)mainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                modInfo.setInitializer(modInitializer);
                modInitializer.onLoad(this.modAPI);
                modInitializer.onEnable();
                this.plugin.getLogger().info("Mod " + modInfo.getName() + " initialized and enabled.");
            } else {
                this.plugin.getLogger().warning("Main class " + modInfo.getMainClass() + " in mod " + modInfo.getName() + " does not implement ModInitializer. Skipping.");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void extractResource(String resourcePath, InputStream inputStream) {
        File outputFile = new File(this.resourceStagingDir, resourcePath);
        outputFile.getParentFile().mkdirs();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream out = new FileOutputStream(outputFile);){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                }
                this.plugin.getLogger().info("Extracted resource: " + resourcePath);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to extract resource: " + resourcePath);
            e.printStackTrace();
        }
    }

    public void disableMods() {
        Collections.reverse(this.loadOrder);
        for (ModInfo modInfo : this.loadOrder) {
            this.plugin.getLogger().info("Disabling mod: " + modInfo.getName());
            try {
                if (modInfo.getInitializer() != null) {
                    modInfo.getInitializer().onDisable();
                }
                if (modInfo.getClassLoader() == null) continue;
                modInfo.getClassLoader().close();
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error disabling mod " + modInfo.getName());
                e.printStackTrace();
            }
        }
        this.loadOrder.clear();
        this.availableMods.clear();
        this.commandRegistry.unregisterAll();
        this.eventListenerRegistry.unregisterAll();
        this.recipeRegistry.unregisterAll();
    }

    public List<ModInfo> getLoadedModsInfo() {
        return Collections.unmodifiableList(this.loadOrder);
    }

    public List<String> getAvailableModNames() {
        return new ArrayList<String>(this.availableMods.keySet());
    }

    public List<String> getEnabledModNames() {
        return this.loadOrder.stream().map(ModInfo::getName).collect(Collectors.toList());
    }

    public boolean isModEnabled(String modName) {
        return this.loadOrder.stream().anyMatch(mod -> mod.getName().equals(modName));
    }

    public ModInfo getModInfo(String modName) {
        return this.availableMods.get(modName);
    }

    public void unloadMod(String modName) throws Exception {
        ModInfo modToUnload = null;
        for (ModInfo mod : this.loadOrder) {
            if (!mod.getName().equals(modName)) continue;
            modToUnload = mod;
            break;
        }
        if (modToUnload == null) {
            throw new IllegalArgumentException("Mod '" + modName + "' is not currently loaded.");
        }
        for (ModInfo mod : this.loadOrder) {
            if (!mod.getDependencies().keySet().contains(modName)) continue;
            throw new IllegalStateException("Mod '" + mod.getName() + "' depends on '" + modName + "'. Cannot unload.");
        }
        this.plugin.getLogger().info("Unloading mod: " + modToUnload.getName());
        if (modToUnload.getInitializer() != null) {
            modToUnload.getInitializer().onDisable();
        }
        if (modToUnload.getClassLoader() != null) {
            modToUnload.getClassLoader().close();
        }
        this.loadOrder.remove(modToUnload);
        this.plugin.getLogger().info("Mod '" + modName + "' unloaded successfully!");
    }

    public void loadMod(String modName) throws Exception {
        ModInfo modToLoad = this.availableMods.get(modName);
        if (modToLoad == null) {
            throw new IllegalArgumentException("Mod '" + modName + "' not found.");
        }
        if (this.isModEnabled(modName)) {
            throw new IllegalStateException("Mod '" + modName + "' is already loaded.");
        }
        this.loadOrder.add(modToLoad);
        try {
            this.loadModloader999(modToLoad);
            this.plugin.getLogger().info("Mod '" + modName + "' loaded successfully!");
        }
        catch (Exception e) {
            this.loadOrder.remove(modToLoad);
            throw e;
        }
    }

    public void enableMod(String modName) throws Exception {
        ModInfo modToEnable = this.availableMods.get(modName);
        if (modToEnable == null) {
            throw new IllegalArgumentException("Mod '" + modName + "' not found.");
        }
        if (this.isModEnabled(modName)) {
            throw new IllegalStateException("Mod '" + modName + "' is already enabled.");
        }
        this.loadOrder.add(modToEnable);
        try {
            this.loadModloader999(modToEnable);
            this.plugin.getLogger().info("Mod '" + modName + "' enabled successfully!");
        }
        catch (Exception e) {
            this.loadOrder.remove(modToEnable);
            throw e;
        }
    }

    public void disableMod(String modName) throws Exception {
        ModInfo modToDisable = null;
        for (ModInfo mod : this.loadOrder) {
            if (!mod.getName().equals(modName)) continue;
            modToDisable = mod;
            break;
        }
        if (modToDisable == null) {
            throw new IllegalArgumentException("Mod '" + modName + "' is not currently enabled.");
        }
        for (ModInfo mod : this.loadOrder) {
            if (!mod.getDependencies().keySet().contains(modName)) continue;
            throw new IllegalStateException("Mod '" + mod.getName() + "' depends on '" + modName + "'. Cannot disable.");
        }
        this.plugin.getLogger().info("Disabling mod: " + modToDisable.getName());
        if (modToDisable.getInitializer() != null) {
            modToDisable.getInitializer().onDisable();
        }
        if (modToDisable.getClassLoader() != null) {
            modToDisable.getClassLoader().close();
        }
        this.loadOrder.remove(modToDisable);
        this.plugin.getLogger().info("Mod '" + modName + "' disabled successfully.");
    }

    private boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            File[] fileArray = allContents;
            int n = allContents.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.deleteDirectory(file);
                ++n2;
            }
        }
        return directoryToBeDeleted.delete();
    }
}

