/*
 * Decompiled with CFR 0.152.
 */
package com.example.modloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.plugin.java.JavaPlugin;

public class ResourcePackGenerator {
    private final JavaPlugin plugin;
    private final File stagingDir;
    private final File zipFile;
    private String zipFileSha1;

    public ResourcePackGenerator(JavaPlugin plugin) {
        this.plugin = plugin;
        this.stagingDir = new File(plugin.getDataFolder(), "resource-pack-staging");
        this.zipFile = new File(plugin.getDataFolder(), "generated-pack.zip");
    }

    public boolean generate() {
        try {
            this.createPackMeta();
            this.zipDirectory(this.stagingDir, this.zipFile);
            this.zipFileSha1 = this.calculateSha1(this.zipFile);
            this.plugin.getLogger().info("Generated resource pack with SHA-1: " + this.zipFileSha1);
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to generate resource pack zip.");
            e.printStackTrace();
            return false;
        }
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public String getZipFileSha1() {
        return this.zipFileSha1;
    }

    private void createPackMeta() throws IOException {
        File packMetaFile = new File(this.stagingDir, "pack.mcmeta");
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter writer = new FileWriter(packMetaFile);){
            writer.write("{\n");
            writer.write("  \"pack\": {\n");
            writer.write("    \"pack_format\": 34,\n");
            writer.write("    \"description\": \"Dynamically generated server resources.\"\n");
            writer.write("  }\n");
            writer.write("}\n");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.plugin.getLogger().info("Created pack.mcmeta file.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void zipDirectory(File dir, File zipFile) throws IOException {
        block13: {
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                FileOutputStream fos = new FileOutputStream(zipFile);
                try {
                    try (ZipOutputStream zos = new ZipOutputStream(fos);){
                        this.addDirToZip(dir, "", zos);
                    }
                    if (fos == null) break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        this.plugin.getLogger().info("Successfully zipped resource pack to: " + zipFile.getPath());
    }

    private void addDirToZip(File dir, String baseName, ZipOutputStream zos) throws IOException {
        File[] files = dir.listFiles();
        byte[] buffer = new byte[4096];
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.addDirToZip(file, baseName + file.getName() + "/", zos);
            } else {
                Throwable throwable = null;
                Object var11_12 = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    int length;
                    zos.putNextEntry(new ZipEntry(baseName + file.getName()));
                    while ((length = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, length);
                    }
                    zos.closeEntry();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ++n2;
        }
    }

    /*
     * Loose catch block
     */
    private String calculateSha1(File file) throws IOException {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                String string;
                DigestInputStream dis;
                FileInputStream fis;
                block20: {
                    block19: {
                        fis = new FileInputStream(file);
                        dis = new DigestInputStream(fis, sha1);
                        while (dis.read() != -1) {
                        }
                        byte[] hash = sha1.digest();
                        StringBuilder hexString = new StringBuilder();
                        byte[] byArray = hash;
                        int n = hash.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte b = byArray[n2];
                            hexString.append(String.format("%02x", b));
                            ++n2;
                        }
                        string = hexString.toString();
                        if (dis == null) break block19;
                        dis.close();
                    }
                    if (fis == null) break block20;
                    fis.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (dis != null) {
                                dis.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to calculate SHA-1 hash.", e);
        }
    }
}

